"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionField = exports.jobSourceConfigurationRT = exports.jobCustomSettingsRT = exports.getJobIdPrefix = exports.getJobId = exports.getDatafeedId = exports.filterDatasetFilter = exports.datasetFilterRT = exports.combineDatasetFilters = exports.categoriesMessageField = exports.bucketSpan = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _uuid = require("uuid");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bucketSpan = 900000;
exports.bucketSpan = bucketSpan;
const categoriesMessageField = 'message';
exports.categoriesMessageField = categoriesMessageField;
const partitionField = 'event.dataset';
exports.partitionField = partitionField;
const ID_NAMESPACE = 'f91b78c0-fdd3-425d-a4ba-4c028fe57e0f';
const getJobIdPrefix = (spaceId, sourceId, idFormat) => {
  if (idFormat === 'legacy') {
    return `kibana-logs-ui-${spaceId}-${sourceId}-`;
  } else {
    // A UUID is 36 characters but based on the ML job names for logs, our limit is 32 characters
    // Thus we remove the 4 dashes
    const uuid = (0, _uuid.v5)(`${spaceId}-${sourceId}`, ID_NAMESPACE).replaceAll('-', '');
    return `logs-${uuid}-`;
  }
};
exports.getJobIdPrefix = getJobIdPrefix;
const getJobId = (spaceId, logViewId, idFormat, jobType) => `${getJobIdPrefix(spaceId, logViewId, idFormat)}${jobType}`;
exports.getJobId = getJobId;
const getDatafeedId = (spaceId, logViewId, idFormat, jobType) => `datafeed-${getJobId(spaceId, logViewId, idFormat, jobType)}`;
exports.getDatafeedId = getDatafeedId;
const datasetFilterRT = rt.union([rt.strict({
  type: rt.literal('includeAll')
}), rt.strict({
  type: rt.literal('includeSome'),
  datasets: rt.array(rt.string)
})]);
exports.datasetFilterRT = datasetFilterRT;
const jobSourceConfigurationRT = rt.partial({
  indexPattern: rt.string,
  timestampField: rt.string,
  bucketSpan: rt.number,
  datasetFilter: datasetFilterRT
});
exports.jobSourceConfigurationRT = jobSourceConfigurationRT;
const jobCustomSettingsRT = rt.partial({
  job_revision: rt.number,
  logs_source_config: jobSourceConfigurationRT
});
exports.jobCustomSettingsRT = jobCustomSettingsRT;
const combineDatasetFilters = (firstFilter, secondFilter) => {
  if (firstFilter.type === 'includeAll' && secondFilter.type === 'includeAll') {
    return {
      type: 'includeAll'
    };
  }
  const includedDatasets = new Set([...(firstFilter.type === 'includeSome' ? firstFilter.datasets : []), ...(secondFilter.type === 'includeSome' ? secondFilter.datasets : [])]);
  return {
    type: 'includeSome',
    datasets: [...includedDatasets]
  };
};
exports.combineDatasetFilters = combineDatasetFilters;
const filterDatasetFilter = (datasetFilter, predicate) => {
  if (datasetFilter.type === 'includeAll') {
    return datasetFilter;
  } else {
    const newDatasets = datasetFilter.datasets.filter(predicate);
    if (newDatasets.length > 0) {
      return {
        type: 'includeSome',
        datasets: newDatasets
      };
    } else {
      return {
        type: 'includeAll'
      };
    }
  }
};
exports.filterDatasetFilter = filterDatasetFilter;