"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleInventoryViewRT = exports.inventoryViewRT = exports.inventoryViewOptionsRT = exports.inventoryViewBasicAttributesRT = exports.inventoryViewAttributesRT = exports.inventorySortOptionRT = exports.inventoryOptionsStateRT = exports.inventoryMapBoundsRT = exports.inventoryFiltersStateRT = exports.inventoryColorPaletteRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _snapshot_api = require("../http_api/snapshot_api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventoryColorPaletteRT = rt.keyof({
  status: null,
  temperature: null,
  cool: null,
  warm: null,
  positive: null,
  negative: null
});
exports.inventoryColorPaletteRT = inventoryColorPaletteRT;
const inventoryLegendOptionsRT = rt.type({
  palette: inventoryColorPaletteRT,
  steps: (0, _ioTsUtils.inRangeRt)(2, 18),
  reverseColors: rt.boolean
});
const inventorySortOptionRT = rt.type({
  by: rt.keyof({
    name: null,
    value: null
  }),
  direction: rt.keyof({
    asc: null,
    desc: null
  })
});
exports.inventorySortOptionRT = inventorySortOptionRT;
const inventoryViewOptionsRT = rt.keyof({
  table: null,
  map: null
});
exports.inventoryViewOptionsRT = inventoryViewOptionsRT;
const inventoryMapBoundsRT = rt.type({
  min: (0, _ioTsUtils.inRangeRt)(0, 1),
  max: (0, _ioTsUtils.inRangeRt)(0, 1)
});
exports.inventoryMapBoundsRT = inventoryMapBoundsRT;
const inventoryFiltersStateRT = rt.type({
  kind: rt.literal('kuery'),
  expression: rt.string
});
exports.inventoryFiltersStateRT = inventoryFiltersStateRT;
const inventoryOptionsStateRT = rt.intersection([rt.type({
  accountId: rt.string,
  autoBounds: rt.boolean,
  boundsOverride: inventoryMapBoundsRT,
  customMetrics: rt.array(_snapshot_api.SnapshotCustomMetricInputRT),
  customOptions: rt.array(rt.type({
    text: rt.string,
    field: rt.string
  })),
  groupBy: _snapshot_api.SnapshotGroupByRT,
  metric: _snapshot_api.SnapshotMetricInputRT,
  nodeType: _common.ItemTypeRT,
  region: rt.string,
  sort: inventorySortOptionRT,
  view: inventoryViewOptionsRT
}), rt.partial({
  legend: inventoryLegendOptionsRT,
  source: rt.string,
  timelineOpen: rt.boolean
})]);
exports.inventoryOptionsStateRT = inventoryOptionsStateRT;
const inventoryViewBasicAttributesRT = rt.type({
  name: _ioTsUtils.nonEmptyStringRt
});
exports.inventoryViewBasicAttributesRT = inventoryViewBasicAttributesRT;
const inventoryViewFlagsRT = rt.partial({
  isDefault: rt.boolean,
  isStatic: rt.boolean
});
const inventoryViewAttributesRT = rt.intersection([inventoryOptionsStateRT, inventoryViewBasicAttributesRT, inventoryViewFlagsRT, rt.type({
  autoReload: rt.boolean,
  filterQuery: inventoryFiltersStateRT
}), rt.partial({
  time: rt.number
})]);
exports.inventoryViewAttributesRT = inventoryViewAttributesRT;
const singleInventoryViewAttributesRT = rt.exact(rt.intersection([inventoryViewBasicAttributesRT, inventoryViewFlagsRT]));
const inventoryViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: inventoryViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));
exports.inventoryViewRT = inventoryViewRT;
const singleInventoryViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: singleInventoryViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));
exports.singleInventoryViewRT = singleInventoryViewRT;