"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMgmtUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _semver = _interopRequireDefault(require("semver/classes/semver"));
var _extension_service = require("./application/store/selectors/extension_service");
var _services = require("./services");
var _plugin = require("../common/constants/plugin");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */ // avoid import from index files in plugin.ts, use specific import paths
class IndexMgmtUIPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "extensionsService", new _services.ExtensionsService());
    this.ctx = ctx;
    // Temporary hack to provide the service instances in module files in order to avoid a big refactor
    // For the selectors we should expose them through app dependencies and read them from there on each container component.
    (0, _extension_service.setExtensionsService)(this.extensionsService);
  }
  setup(coreSetup, plugins) {
    const {
      ui: {
        enabled: isIndexManagementUiEnabled
      },
      enableIndexActions,
      enableLegacyTemplates,
      enableIndexStats,
      editableIndexSettings,
      enableDataStreamsStorageColumn
    } = this.ctx.config.get();
    if (isIndexManagementUiEnabled) {
      const {
        fleet,
        usageCollection,
        management,
        cloud
      } = plugins;
      const kibanaVersion = new _semver.default(this.ctx.env.packageInfo.version);
      const config = {
        enableIndexActions: enableIndexActions !== null && enableIndexActions !== void 0 ? enableIndexActions : true,
        enableLegacyTemplates: enableLegacyTemplates !== null && enableLegacyTemplates !== void 0 ? enableLegacyTemplates : true,
        enableIndexStats: enableIndexStats !== null && enableIndexStats !== void 0 ? enableIndexStats : true,
        editableIndexSettings: editableIndexSettings !== null && editableIndexSettings !== void 0 ? editableIndexSettings : 'all',
        enableDataStreamsStorageColumn: enableDataStreamsStorageColumn !== null && enableDataStreamsStorageColumn !== void 0 ? enableDataStreamsStorageColumn : true
      };
      management.sections.section.data.registerApp({
        id: _plugin.PLUGIN.id,
        title: _i18n.i18n.translate('xpack.idxMgmt.appTitle', {
          defaultMessage: 'Index Management'
        }),
        order: 0,
        mount: async params => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          return mountManagementSection({
            coreSetup,
            usageCollection,
            params,
            extensionsService: this.extensionsService,
            isFleetEnabled: Boolean(fleet),
            kibanaVersion,
            config,
            cloud
          });
        }
      });
    }
    return {
      apiService: new _services.PublicApiService(coreSetup.http),
      extensionsService: this.extensionsService.setup()
    };
  }
  start() {
    return {
      extensionsService: this.extensionsService.setup()
    };
  }
  stop() {}
}
exports.IndexMgmtUIPlugin = IndexMgmtUIPlugin;