"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "extensionsService", {
  enumerable: true,
  get: function () {
    return _extension_service.extensionsService;
  }
});
exports.isSortAscending = exports.indicesLoading = exports.indicesError = exports.getTotalItems = exports.getTableState = exports.getTableLocationProp = exports.getSortField = exports.getRowStatuses = exports.getPager = exports.getPageOfIndices = exports.getIndicesByName = exports.getIndicesAsArray = exports.getIndices = exports.getIndexStatusByIndexName = exports.getIndexByIndexName = exports.getFilteredIndices = exports.getFilteredIds = exports.getFilter = exports.getAllIds = void 0;
var _eui = require("@elastic/eui");
var _reselect = require("reselect");
var qs = _interopRequireWildcard(require("query-string"));
var _index_status_labels = require("../../lib/index_status_labels");
var _indices = require("../../lib/indices");
var _services = require("../../services");
var _extension_service = require("./extension_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndices = state => state.indices.byId;
exports.getIndices = getIndices;
const indicesLoading = state => state.indices.loading;
exports.indicesLoading = indicesLoading;
const indicesError = state => state.indices.error;
exports.indicesError = indicesError;
const getIndicesAsArray = state => Object.values(state.indices.byId);
exports.getIndicesAsArray = getIndicesAsArray;
const getIndicesByName = (state, indexNames) => {
  const indices = getIndices(state);
  return indexNames.map(indexName => indices[indexName]);
};
exports.getIndicesByName = getIndicesByName;
const getIndexByIndexName = (state, name) => getIndices(state)[name];
exports.getIndexByIndexName = getIndexByIndexName;
const getFilteredIds = state => state.indices.filteredIds;
exports.getFilteredIds = getFilteredIds;
const getRowStatuses = state => state.rowStatus;
exports.getRowStatuses = getRowStatuses;
const getTableState = state => state.tableState;
exports.getTableState = getTableState;
const getTableLocationProp = (_, props) => props.location;
exports.getTableLocationProp = getTableLocationProp;
const getAllIds = state => state.indices.allIds;
exports.getAllIds = getAllIds;
const getIndexStatusByIndexName = (state, indexName) => {
  const indices = getIndices(state);
  const {
    status
  } = indices[indexName] || {};
  return status;
};
exports.getIndexStatusByIndexName = getIndexStatusByIndexName;
const defaultFilterFields = ['name'];
const filterByToggles = (indices, toggleNameToVisibleMap) => {
  const togglesByName = _extension_service.extensionsService.toggles.reduce((byName, toggle) => ({
    ...byName,
    [toggle.name]: toggle
  }), {});
  const toggleNames = Object.keys(togglesByName);
  if (!toggleNames.length) {
    return indices;
  }
  // An index is visible if ANY applicable toggle is visible.
  return indices.filter(index => {
    return toggleNames.some(toggleName => {
      if (!togglesByName[toggleName].matchIndex(index)) {
        return true;
      }
      const isVisible = toggleNameToVisibleMap[toggleName] === true;
      return isVisible;
    });
  });
};
const getFilteredIndices = (0, _reselect.createSelector)(getIndices, getAllIds, getTableState, getTableLocationProp, (indices, allIds, tableState, tableLocation) => {
  let indexArray = allIds.map(indexName => indices[indexName]);
  indexArray = filterByToggles(indexArray, tableState.toggleNameToVisibleMap);
  const {
    includeHiddenIndices: includeHiddenParam
  } = qs.parse(tableLocation.search);
  const includeHidden = includeHiddenParam === 'true';
  const filteredIndices = includeHidden ? indexArray : indexArray.filter(index => !(0, _indices.isHiddenIndex)(index));
  const filter = tableState.filter || _eui.EuiSearchBar.Query.MATCH_ALL;
  return _eui.EuiSearchBar.Query.execute(filter, filteredIndices, {
    defaultFields: defaultFilterFields
  });
});
exports.getFilteredIndices = getFilteredIndices;
const getTotalItems = (0, _reselect.createSelector)(getFilteredIndices, filteredIndices => {
  return Object.keys(filteredIndices).length;
});
exports.getTotalItems = getTotalItems;
const getPager = (0, _reselect.createSelector)(getTableState, getTotalItems, ({
  currentPage,
  pageSize
}, totalItems) => {
  return new _eui.Pager(totalItems, pageSize, currentPage);
});
exports.getPager = getPager;
const getPageOfIndices = (0, _reselect.createSelector)(getFilteredIndices, getTableState, getRowStatuses, getPager, (filteredIndices, tableState, rowStatuses, pager) => {
  const sortedIndexes = (0, _services.sortTable)(filteredIndices, tableState.sortField, tableState.isSortAscending);
  const {
    firstItemIndex,
    lastItemIndex
  } = pager;
  const pagedIndexes = sortedIndexes.slice(firstItemIndex, lastItemIndex + 1);
  return pagedIndexes.map(index => {
    if (index.status) {
      const status = _index_status_labels.indexStatusLabels[rowStatuses[index.name]] ||
      // user friendly version of row status
      rowStatuses[index.name] ||
      // row status
      _index_status_labels.indexStatusLabels[index.status] ||
      // user friendly version of index status
      index.status; // index status
      return {
        ...index,
        status
      };
    }
    return index;
  });
});
exports.getPageOfIndices = getPageOfIndices;
const getFilter = (0, _reselect.createSelector)(getTableState, ({
  filter
}) => filter);
exports.getFilter = getFilter;
const isSortAscending = (0, _reselect.createSelector)(getTableState, ({
  isSortAscending
}) => isSortAscending);
exports.isSortAscending = isSortAscending;
const getSortField = (0, _reselect.createSelector)(getTableState, ({
  sortField
}) => sortField);
exports.getSortField = getSortField;