"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _queryString = _interopRequireDefault(require("query-string"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _constants = require("../../../../constants");
var _routing = require("../../../../services/routing");
var _documentation = require("../../../../services/documentation");
var _app_context = require("../../../../app_context");
var _render_badges = require("../../../../lib/render_badges");
var _components = require("../../../../components");
var _index_actions_context_menu = require("../index_actions_context_menu");
var _create_index_button = require("../create_index/create_index_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHeaders = ({
  showIndexStats
}) => {
  const headers = {};
  headers.name = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.nameHeader', {
    defaultMessage: 'Name'
  });
  if (showIndexStats) {
    headers.health = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.healthHeader', {
      defaultMessage: 'Health'
    });
    headers.status = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.statusHeader', {
      defaultMessage: 'Status'
    });
    headers.primary = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.primaryHeader', {
      defaultMessage: 'Primaries'
    });
    headers.replica = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.replicaHeader', {
      defaultMessage: 'Replicas'
    });
    headers.documents = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.documentsHeader', {
      defaultMessage: 'Docs count'
    });
    headers.size = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.storageSizeHeader', {
      defaultMessage: 'Storage size'
    });
  }
  headers.data_stream = _i18n.i18n.translate('xpack.idxMgmt.indexTable.headers.dataStreamHeader', {
    defaultMessage: 'Data stream'
  });
  return headers;
};
class IndexTable extends _react.Component {
  static getDerivedStateFromProps(props, state) {
    // Deselect any indices which no longer exist, e.g. they've been deleted.
    const {
      selectedIndicesMap
    } = state;
    const indexNames = props.indices.map(index => index.name);
    const selectedIndexNames = Object.keys(selectedIndicesMap);
    const missingIndexNames = selectedIndexNames.filter(selectedIndexName => {
      return !indexNames.includes(selectedIndexName);
    });
    if (missingIndexNames.length) {
      const newMap = {
        ...selectedIndicesMap
      };
      missingIndexNames.forEach(missingIndexName => delete newMap[missingIndexName]);
      return {
        selectedIndicesMap: newMap
      };
    }
    return null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSort", column => {
      const {
        sortField,
        isSortAscending,
        sortChanged
      } = this.props;
      const newIsSortAscending = sortField === column ? !isSortAscending : true;
      sortChanged(column, newIsSortAscending);
    });
    (0, _defineProperty2.default)(this, "onFilterChanged", ({
      query,
      error
    }) => {
      if (error) {
        this.setState({
          filterError: error
        });
      } else {
        this.props.filterChanged(query);
        this.setState({
          filterError: null
        });
      }
    });
    (0, _defineProperty2.default)(this, "getFilters", extensionsService => {
      const {
        allIndices
      } = this.props;
      return extensionsService.filters.reduce((accum, filterExtension) => {
        const filtersToAdd = filterExtension(allIndices);
        return [...accum, ...filtersToAdd];
      }, []);
    });
    (0, _defineProperty2.default)(this, "toggleAll", () => {
      const allSelected = this.areAllItemsSelected();
      if (allSelected) {
        return this.setState({
          selectedIndicesMap: {}
        });
      }
      const {
        indices
      } = this.props;
      const selectedIndicesMap = {};
      indices.forEach(({
        name
      }) => {
        selectedIndicesMap[name] = true;
      });
      this.setState({
        selectedIndicesMap
      });
    });
    (0, _defineProperty2.default)(this, "toggleItem", name => {
      this.setState(({
        selectedIndicesMap
      }) => {
        const newMap = {
          ...selectedIndicesMap
        };
        if (newMap[name]) {
          delete newMap[name];
        } else {
          newMap[name] = true;
        }
        return {
          selectedIndicesMap: newMap
        };
      });
    });
    (0, _defineProperty2.default)(this, "isItemSelected", name => {
      return !!this.state.selectedIndicesMap[name];
    });
    (0, _defineProperty2.default)(this, "areAllItemsSelected", () => {
      const {
        indices
      } = this.props;
      const indexOfUnselectedItem = indices.findIndex(index => !this.isItemSelected(index.name));
      return indexOfUnselectedItem === -1;
    });
    (0, _defineProperty2.default)(this, "onItemSelectionChanged", selectedIndices => {
      this.setState({
        selectedIndices
      });
    });
    this.state = {
      selectedIndicesMap: {}
    };
  }
  componentDidMount() {
    this.props.loadIndices();
    this.interval = setInterval(() => this.props.reloadIndices(this.props.indices.map(i => i.name), {
      asSystemRequest: true
    }), _constants.REFRESH_RATE_INDEX_LIST);
    const {
      location,
      filterChanged
    } = this.props;
    const {
      filter
    } = _queryString.default.parse(location && location.search || '');
    if (filter) {
      const decodedFilter = (0, _shared_imports.attemptToURIDecode)(filter);
      try {
        const filter = _eui.EuiSearchBar.Query.parse(decodedFilter);
        filterChanged(filter);
      } catch (e) {
        this.setState({
          filterError: e
        });
      }
    }
  }
  componentWillUnmount() {
    // When you deep-link to an index from the data streams tab, the hidden indices are toggled on.
    // However, this state is lost when you navigate away. We need to clear the filter too, or else
    // navigating back to this tab would just show an empty list because the backing indices
    // would be hidden.
    this.props.filterChanged('');
    clearInterval(this.interval);
  }
  readURLParams() {
    const {
      location
    } = this.props;
    const {
      includeHiddenIndices
    } = _queryString.default.parse(location && location.search || '');
    return {
      includeHiddenIndices: includeHiddenIndices === 'true'
    };
  }
  setIncludeHiddenParam(hidden) {
    const {
      pathname,
      search
    } = this.props.location;
    const params = _queryString.default.parse(search);
    if (hidden) {
      params.includeHiddenIndices = 'true';
    } else {
      delete params.includeHiddenIndices;
    }
    this.props.history.push(pathname + '?' + _queryString.default.stringify(params));
  }
  renderFilterError() {
    const {
      filterError
    } = this.state;
    if (!filterError) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "faceSad",
      color: "danger",
      title: _i18n.i18n.translate('xpack.idxMgmt.indexTable.invalidSearchErrorMessage', {
        defaultMessage: 'Invalid search: {errorMessage}',
        values: {
          errorMessage: filterError.message
        }
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }
  buildHeader(config) {
    const {
      sortField,
      isSortAscending
    } = this.props;
    const headers = getHeaders({
      showIndexStats: config.enableIndexStats
    });
    return Object.entries(headers).map(([fieldName, label]) => {
      const isSorted = sortField === fieldName;
      // we only want to make index name column 25% width when there are more columns displayed
      const widthClassName = fieldName === 'name' && config.enableIndexStats ? 'indTable__header__width' : '';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
        key: fieldName,
        onSort: () => this.onSort(fieldName),
        isSorted: isSorted,
        isSortAscending: isSortAscending,
        className: widthClassName,
        "data-test-subj": `indexTableHeaderCell-${fieldName}`
      }, label);
    });
  }
  buildRowCell(fieldName, value, index, appServices) {
    const {
      filterChanged,
      history
    } = this.props;
    if (fieldName === 'health') {
      return /*#__PURE__*/_react.default.createElement(_components.DataHealth, {
        health: value
      });
    } else if (fieldName === 'name') {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "indexTableIndexNameLink",
        onClick: () => history.push((0, _routing.getIndexDetailsLink)(value))
      }, value), (0, _render_badges.renderBadges)(index, appServices.extensionsService, filterChanged));
    } else if (fieldName === 'data_stream' && value) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "dataStreamLink"
      }, (0, _shared_imports.reactRouterNavigate)(history, {
        pathname: (0, _routing.getDataStreamDetailsLink)(value),
        search: '?isDeepLink=true'
      })), value);
    } else if (fieldName === 'documents' && value) {
      return Number(value).toLocaleString();
    }
    return value;
  }
  buildRowCells(index, appServices, config) {
    const headers = getHeaders({
      showIndexStats: config.enableIndexStats
    });
    return Object.keys(headers).map(fieldName => {
      const {
        name
      } = index;
      const value = index[fieldName];
      if (fieldName === 'name') {
        return /*#__PURE__*/_react.default.createElement("th", {
          key: `${fieldName}-${name}`,
          className: "euiTableRowCell",
          scope: "row",
          "data-test-subj": `indexTableCell-${fieldName}`
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: `euiTableCellContent indTable__cell--${fieldName}`
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "eui-textLeft"
        }, this.buildRowCell(fieldName, value, index, appServices))));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        key: `${fieldName}-${name}`,
        truncateText: false,
        "data-test-subj": `indexTableCell-${fieldName}`,
        className: 'indTable__cell--' + fieldName,
        header: fieldName
      }, this.buildRowCell(fieldName, value, index, appServices));
    });
  }
  renderBanners(extensionsService) {
    const {
      allIndices = [],
      filterChanged
    } = this.props;
    return extensionsService.banners.map((bannerExtension, i) => {
      const bannerData = bannerExtension(allIndices);
      if (!bannerData) {
        return null;
      }
      const {
        type,
        title,
        message,
        filter,
        filterLabel
      } = bannerData;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: `bannerExtension${i}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: type,
        size: "m",
        title: title
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, message, filter ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => filterChanged(filter)
      }, filterLabel) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }));
    });
  }
  buildRows(appServices, config) {
    const {
      indices = []
    } = this.props;
    return indices.map(index => {
      const {
        name
      } = index;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        "data-test-subj": "indexTableRow",
        isSelected: this.isItemSelected(name),
        isSelectable: true,
        key: `${name}-row`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, {
        key: `checkbox-${name}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        type: "inList",
        id: `checkboxSelectIndex-${name}`,
        checked: this.isItemSelected(name),
        onChange: () => {
          this.toggleItem(name);
        },
        "data-test-subj": "indexTableRowCheckbox",
        "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexTable.selectIndexAriaLabel', {
          defaultMessage: 'Select this row'
        })
      })), this.buildRowCells(index, appServices, config));
    });
  }
  renderPager() {
    const {
      pager,
      pageChanged,
      pageSizeChanged
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
      activePage: pager.getCurrentPageIndex(),
      itemsPerPage: pager.itemsPerPage,
      itemsPerPageOptions: [10, 50, 100],
      pageCount: pager.getTotalPages(),
      onChangeItemsPerPage: pageSizeChanged,
      onChangePage: pageChanged
    });
  }
  renderToggleControl({
    name,
    label
  }) {
    const {
      toggleNameToVisibleMap,
      toggleChanged
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: name,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: `checkboxToggles-${name}`,
      "data-test-subj": `checkboxToggles-${name}`,
      checked: toggleNameToVisibleMap[name],
      onChange: event => toggleChanged(name, event.target.checked),
      label: label
    }));
  }
  render() {
    const {
      filter,
      indices,
      loadIndices,
      indicesLoading,
      indicesError,
      allIndices,
      pager
    } = this.props;
    const {
      includeHiddenIndices
    } = this.readURLParams();
    const hasContent = !indicesLoading && !indicesError;
    if (!hasContent) {
      if (indicesLoading) {
        return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.indexTable.loadingIndicesDescription",
          defaultMessage: "Loading indices\u2026"
        }));
      }
      if (indicesError) {
        if (indicesError.status === 403) {
          return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.idxMgmt.pageErrorForbidden.title",
              defaultMessage: "You do not have permissions to use Index Management"
            })
          });
        }
        return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.indexTable.serverErrorTitle",
            defaultMessage: "Error loading indices"
          }),
          error: indicesError.body
        });
      }
    }
    const {
      selectedIndicesMap
    } = this.state;
    const atLeastOneItemSelected = Object.keys(selectedIndicesMap).length > 0;
    return /*#__PURE__*/_react.default.createElement(_app_context.AppContextConsumer, null, ({
      services,
      config
    }) => {
      const {
        extensionsService
      } = services;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        paddingSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.idxMgmtDescription",
        defaultMessage: "Update your Elasticsearch indices individually or in bulk. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _documentation.documentationService.getIdxMgmtDocumentationLink(),
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.idxMgmt.indexTableDescription.learnMoreLinkText', {
            defaultMessage: 'Learn more.'
          }))
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, indicesLoading && allIndices.length === 0 || indicesError ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, extensionsService.toggles.map(toggle => {
        return this.renderToggleControl(toggle);
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        id: "checkboxShowHiddenIndices",
        "data-test-subj": "indexTableIncludeHiddenIndicesToggle",
        checked: includeHiddenIndices,
        onChange: event => this.setIncludeHiddenParam(event.target.checked),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.indexTable.hiddenIndicesSwitchLabel",
          defaultMessage: "Include hidden indices"
        })
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), this.renderBanners(extensionsService), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "l",
        alignItems: "center"
      }, atLeastOneItemSelected ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
        key: "menu",
        render: () => /*#__PURE__*/_react.default.createElement(_index_actions_context_menu.IndexActionsContextMenu, {
          indexNames: Object.keys(selectedIndicesMap),
          isOnListView: true,
          resetSelection: () => {
            this.setState({
              selectedIndicesMap: {}
            });
          }
        })
      })) : null, indicesLoading && allIndices.length === 0 || indicesError ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
        filters: this.getFilters(extensionsService).length > 0 ? this.getFilters(extensionsService) : null,
        defaultQuery: filter,
        query: filter,
        box: {
          incremental: true,
          placeholder: _i18n.i18n.translate('xpack.idxMgmt.indexTable.systemIndicesSearchInputPlaceholder', {
            defaultMessage: 'Search'
          })
        },
        "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexTable.systemIndicesSearchIndicesAriaLabel', {
          defaultMessage: 'Search indices'
        }),
        "data-test-subj": "indexTableFilterInput",
        onChange: this.onFilterChanged
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        isLoading: indicesLoading,
        color: "success",
        onClick: () => {
          loadIndices();
        },
        iconType: "refresh",
        "data-test-subj": "reloadIndicesButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTable.reloadIndicesButton",
        defaultMessage: "Reload indices"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_create_index_button.CreateIndexButton, {
        loadIndices: loadIndices
      }))), this.renderFilterError(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), indices.length > 0 ? /*#__PURE__*/_react.default.createElement("div", {
        style: {
          maxWidth: '100%',
          overflow: 'auto'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
        className: "indTable",
        "data-test-subj": "indexTable"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("caption", {
        role: "status",
        "aria-relevant": "text",
        "aria-live": "polite"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexTable.captionText",
        defaultMessage: "Below is the indices table containing {count, plural, one {# row} other {# rows}} out of {total}.",
        values: {
          count: indices.length,
          total: pager.totalItems
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCellCheckbox, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "selectAllIndexes",
        checked: this.areAllItemsSelected(),
        onChange: this.toggleAll,
        type: "inList",
        "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexTable.selectAllIndicesAriaLabel', {
          defaultMessage: 'Select all rows'
        })
      })), this.buildHeader(config)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, this.buildRows(services, config)))) : /*#__PURE__*/_react.default.createElement(_components.NoMatch, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), indices.length > 0 ? this.renderPager() : null);
    });
  }
}
exports.IndexTable = IndexTable;