"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/es-ui-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _routing = require("../../../../../services/routing");
var _ = require("../../../../../..");
var _api = require("../../../../../services/api");
var _app_context = require("../../../../../app_context");
var _humanize_time_stamp = require("../../../data_stream_list/humanize_time_stamp");
var _overview_card = require("./overview_card");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamDetails = ({
  dataStreamName
}) => {
  var _dataStream$name, _dataStream$indexTemp;
  const {
    error,
    data: dataStream,
    isLoading,
    resendRequest
  } = (0, _api.useLoadDataStream)(dataStreamName);
  const {
    history
  } = (0, _app_context.useAppContext)();
  const hasError = !isLoading && (error || !dataStream);
  let contentLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
            font-size: ${_uiTheme.euiThemeVars.euiFontSizeL};
          `
  }, dataStream === null || dataStream === void 0 ? void 0 : dataStream.generation)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.generationLabel', {
    defaultMessage: '{generations, plural, one {Generation} other {Generations}}',
    values: {
      generations: dataStream === null || dataStream === void 0 ? void 0 : dataStream.generation
    }
  }))));
  let contentRight = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    size: "s"
  }, (0, _public.reactRouterNavigate)(history, (0, _routing.getDataStreamDetailsLink)((_dataStream$name = dataStream === null || dataStream === void 0 ? void 0 : dataStream.name) !== null && _dataStream$name !== void 0 ? _dataStream$name : ''))), _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.dataStreamLinkLabel', {
    defaultMessage: 'See details'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    size: "s"
  }, (0, _public.reactRouterNavigate)(history, (0, _.getTemplateDetailsLink)((_dataStream$indexTemp = dataStream === null || dataStream === void 0 ? void 0 : dataStream.indexTemplateName) !== null && _dataStream$indexTemp !== void 0 ? _dataStream$indexTemp : ''))), _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.templateLinkLabel', {
    defaultMessage: 'Related template'
  }))));
  if (isLoading) {
    contentLeft = /*#__PURE__*/_react.default.createElement(_public2.SectionLoading, {
      inline: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.overviewTab.dataStream.loadingDescription",
      defaultMessage: "Loading data stream details\u2026"
    }));
    contentRight = null;
  }
  if (hasError) {
    contentLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.overviewTab.dataStream.errorDescription",
      defaultMessage: "Unable to load data stream details"
    })));
    contentRight = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "warning",
      onClick: resendRequest,
      "data-test-subj": "indexDetailsDataStreamReload"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.overviewTab.dataStream.reloadButtonLabel",
      defaultMessage: "Reload"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    "data-test-subj": "indexDetailsDataStream",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.cardTitle', {
      defaultMessage: 'Data stream'
    }),
    content: {
      left: contentLeft,
      right: contentRight
    },
    footer: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "calendar"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.lastUpdateLabel', {
        defaultMessage: 'Last update'
      })), !isLoading && !hasError && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, dataStream !== null && dataStream !== void 0 && dataStream.maxTimeStamp ? (0, _humanize_time_stamp.humanizeTimeStamp)(dataStream.maxTimeStamp) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.dataStream.maxTimeStampNoneMessage', {
        defaultMessage: `Never`
      }))))
    }
  });
};
exports.DataStreamDetails = DataStreamDetails;