"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichPolicyCreate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../services/documentation");
var _breadcrumbs = require("../../services/breadcrumbs");
var _create_policy_wizard = require("./create_policy_wizard");
var _create_policy_context = require("./create_policy_context");
var _enrich_policies = require("../../components/enrich_policies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateView = () => {
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.enrichPoliciesCreate);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_create_policy_context.CreatePolicyContextProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "createEnrichPolicyHeaderContent",
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.appTitle",
      defaultMessage: "Create enrich policy"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.appDescription",
      defaultMessage: "Specify how to retrieve and enrich your incoming data."
    }),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: _documentation.documentationService.getCreateEnrichPolicyLink(),
      target: "_blank",
      iconType: "help",
      "data-test-subj": "createEnrichPolicyDocumentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicyCreate.titleDocsLinkText",
      defaultMessage: "Documentation"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_create_policy_wizard.CreatePolicyWizard, null));
};
const EnrichPolicyCreate = props => /*#__PURE__*/_react.default.createElement(_enrich_policies.EnrichPoliciesAuthProvider, null, /*#__PURE__*/_react.default.createElement(_enrich_policies.EnrichPoliciesWithPrivileges, null, /*#__PURE__*/_react.default.createElement(CreateView, props)));
exports.EnrichPolicyCreate = EnrichPolicyCreate;