"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMappingsState = exports.useDispatch = exports.StateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reducer = require("./reducer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StateContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const DispatchContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const StateProvider = ({
  children
}) => {
  const initialState = {
    isValid: true,
    configuration: {
      defaultValue: {},
      data: {
        internal: {},
        format: () => ({})
      },
      validate: () => Promise.resolve(true)
    },
    templates: {
      defaultValue: {},
      data: {
        internal: {},
        format: () => ({})
      },
      validate: () => Promise.resolve(true)
    },
    fields: {
      byId: {},
      rootLevelFields: [],
      aliases: {},
      maxNestedDepth: 0
    },
    documentFields: {
      status: 'idle',
      editor: 'default'
    },
    runtimeFields: {},
    runtimeFieldsList: {
      status: 'idle'
    },
    fieldsJsonEditor: {
      format: () => ({}),
      isValid: true
    },
    search: {
      term: '',
      result: []
    }
  };
  const [state, dispatch] = (0, _react.useReducer)(_reducer.reducer, initialState);
  return /*#__PURE__*/_react.default.createElement(StateContext.Provider, {
    value: state
  }, /*#__PURE__*/_react.default.createElement(DispatchContext.Provider, {
    value: dispatch
  }, children));
};
exports.StateProvider = StateProvider;
const useMappingsState = () => {
  const ctx = (0, _react.useContext)(StateContext);
  if (ctx === undefined) {
    throw new Error('useMappingsState must be used within a <MappingsState>');
  }
  return ctx;
};
exports.useMappingsState = useMappingsState;
const useDispatch = () => {
  const ctx = (0, _react.useContext)(DispatchContext);
  if (ctx === undefined) {
    throw new Error('useDispatch must be used within a <MappingsState>');
  }
  return ctx;
};
exports.useDispatch = useDispatch;