"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplatesForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _mappings_state_context = require("../../mappings_state_context");
var _templates_form_schema = require("./templates_form_schema");
var _documentation = require("../../../../services/documentation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringifyJson = json => Array.isArray(json) ? JSON.stringify(json, null, 2) : '[\n\n]';
const formSerializer = formData => {
  const {
    dynamicTemplates
  } = formData;
  let parsedTemplates;
  try {
    parsedTemplates = JSON.parse(dynamicTemplates);
    if (!Array.isArray(parsedTemplates)) {
      // User provided an object, but we need an array of objects
      parsedTemplates = [parsedTemplates];
    }
  } catch {
    // Silently swallow errors
  }
  return {
    dynamic_templates: Array.isArray(parsedTemplates) && parsedTemplates.length > 0 ? parsedTemplates : []
  };
};
const formDeserializer = formData => {
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const {
    dynamic_templates
  } = formData;
  return {
    dynamicTemplates: stringifyJson(dynamic_templates)
  };
};
const TemplatesForm = /*#__PURE__*/_react.default.memo(({
  value
}) => {
  const isMounted = (0, _react.useRef)(false);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _templates_form_schema.templatesFormSchema,
    serializer: formSerializer,
    deserializer: formDeserializer,
    defaultValue: value
  });
  const {
    subscribe,
    getFormData,
    submit: submitForm,
    reset
  } = form;
  const dispatch = (0, _mappings_state_context.useDispatch)();
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid,
      validate
    }) => {
      dispatch({
        type: 'templates.update',
        value: {
          data,
          isValid,
          validate,
          submitForm
        }
      });
    });
    return subscription.unsubscribe;
  }, [subscribe, dispatch, submitForm]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      // If the value has changed (it probably means that we have loaded a new JSON)
      // we need to reset the form to update the fields values.
      reset({
        resetValues: true,
        defaultValue: value
      });
    }
  }, [value, reset]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;

      // On unmount => save in the state a snapshot of the current form data.
      const dynamicTemplatesData = getFormData();
      dispatch({
        type: 'templates.save',
        value: dynamicTemplatesData
      });
    };
  }, [getFormData, dispatch]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dynamicTemplates"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.dynamicTemplatesDescription",
    defaultMessage: "Use dynamic templates to define custom mappings that can be applied to dynamically added fields. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getDynamicTemplatesLink(),
        target: "_blank"
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicTemplatesDocumentationLink', {
        defaultMessage: 'Learn more.'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    isInvalid: form.isSubmitted && !form.isValid,
    error: form.getErrors()
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "dynamicTemplates",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        ['data-test-subj']: 'dynamicTemplatesEditor',
        height: '600px',
        'aria-label': _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.dynamicTemplatesEditorAriaLabel', {
          defaultMessage: 'Dynamic templates editor'
        })
      }
    }
  })));
});
exports.TemplatesForm = TemplatesForm;