"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _fields_list = require("./fields_list");
var _create_field = require("./create_field");
var _delete_field_provider = require("./delete_field_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  addMultiFieldButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addMultiFieldTooltipLabel', {
    defaultMessage: 'Add a multi-field to index the same field in different ways.'
  }),
  addPropertyButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.addPropertyButtonLabel', {
    defaultMessage: 'Add property'
  }),
  editButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldButtonLabel', {
    defaultMessage: 'Edit'
  }),
  deleteButtonLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.removeFieldButtonLabel', {
    defaultMessage: 'Remove'
  }),
  fieldIsShadowedLabel: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldIsShadowedLabel', {
    defaultMessage: 'Field shadowed by a runtime field with the same name.'
  })
};
function FieldListItemComponent({
  field,
  allFields,
  isHighlighted,
  isDimmed,
  isCreateFieldFormVisible,
  areActionButtonsVisible,
  isLastItem,
  isShadowed = false,
  childFieldsArray,
  maxNestedDepth,
  addField,
  editField,
  toggleExpand,
  treeDepth
}, ref) {
  const {
    source,
    isMultiField,
    canHaveChildFields,
    hasChildFields,
    canHaveMultiFields,
    hasMultiFields,
    isExpanded,
    path
  } = field;

  // When there aren't any "child" fields (the maxNestedDepth === 0), there is no toggle icon on the left of any field.
  // For that reason, we need to compensate and substract some indent to left align on the page.
  const substractIndentAmount = maxNestedDepth === 0 ? _constants.CHILD_FIELD_INDENT_SIZE * 0.5 : 0;
  const indent = treeDepth * _constants.CHILD_FIELD_INDENT_SIZE - substractIndentAmount;
  const indentCreateField = (treeDepth + 1) * _constants.CHILD_FIELD_INDENT_SIZE + _constants.LEFT_PADDING_SIZE_FIELD_ITEM_WRAPPER - substractIndentAmount;
  const hasDottedLine = isMultiField ? isLastItem ? false : true : canHaveMultiFields && isExpanded;
  const renderCreateField = () => {
    if (!isCreateFieldFormVisible) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_create_field.CreateField, {
      allFields: allFields,
      isRootLevelField: false,
      isMultiField: canHaveMultiFields,
      paddingLeft: indentCreateField,
      maxNestedDepth: maxNestedDepth
    });
  };
  const renderActionButtons = () => {
    if (!areActionButtonsVisible) {
      return null;
    }
    const {
      addMultiFieldButtonLabel,
      addPropertyButtonLabel,
      editButtonLabel,
      deleteButtonLabel
    } = i18nTexts;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      className: "mappingsEditor__fieldsListItem__actions"
    }, canHaveMultiFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: addMultiFieldButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "documents",
      onClick: addField,
      "data-test-subj": "addMultiFieldButton",
      "aria-label": addMultiFieldButtonLabel
    }))), canHaveChildFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: addPropertyButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      onClick: addField,
      "data-test-subj": "addPropertyButton",
      "aria-label": addPropertyButtonLabel
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: editButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: editField,
      "data-test-subj": "editFieldButton",
      "aria-label": editButtonLabel
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_delete_field_provider.DeleteFieldProvider, null, deleteField => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: deleteButtonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => deleteField(field),
      "data-test-subj": "removeFieldButton",
      "aria-label": deleteButtonLabel
    })))));
  };
  const dataTestSubj = `${path.join('')}Field`;
  return /*#__PURE__*/_react.default.createElement("li", {
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem', {
      'mappingsEditor__fieldsListItem--dottedLine': hasDottedLine
    }),
    "data-test-subj": `fieldsListItem ${dataTestSubj}`,
    ref: ref
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingLeft: `${indent}px`
    },
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__field', {
      'mappingsEditor__fieldsListItem__field--enabled': areActionButtonsVisible,
      'mappingsEditor__fieldsListItem__field--highlighted': isHighlighted,
      'mappingsEditor__fieldsListItem__field--dim': isDimmed
    })
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__wrapper', {
      'mappingsEditor__fieldsListItem__wrapper--indent': treeDepth === 0 && maxNestedDepth === 0
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    className: (0, _classnames.default)('mappingsEditor__fieldsListItem__content', {
      'mappingsEditor__fieldsListItem__content--toggle': hasChildFields || hasMultiFields,
      'mappingsEditor__fieldsListItem__content--multiField': isMultiField,
      'mappingsEditor__fieldsListItem__content--indent': !hasChildFields && !hasMultiFields && maxNestedDepth > treeDepth
    })
  }, (hasChildFields || hasMultiFields) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mappingsEditor__fieldsListItem__toggle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: toggleExpand,
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    "data-test-subj": "toggleExpandButton",
    "aria-label": isExpanded ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.collapseFieldButtonLabel', {
      defaultMessage: 'Collapse field {name}',
      values: {
        name: source.name
      }
    }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.expandFieldButtonLabel', {
      defaultMessage: 'Expand field {name}',
      values: {
        name: source.name
      }
    })
  })), isMultiField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mappingsEditor__fieldsListItem__icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mappingsEditor__fieldsListItem__name",
    "data-test-subj": `fieldName ${dataTestSubj}-fieldName`
  }, source.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": `${dataTestSubj}-datatype`,
    "data-type-value": source.type
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.multiFieldBadgeLabel', {
    defaultMessage: '{dataType} multi-field',
    values: {
      dataType: (0, _lib.getTypeLabelFromField)(source)
    }
  }) : (0, _lib.getTypeLabelFromField)(source))), isShadowed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18nTexts.fieldIsShadowedLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    "data-test-subj": "isShadowedIndicator"
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.shadowedBadgeLabel', {
    defaultMessage: 'Shadowed'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderActionButtons())))), Boolean(childFieldsArray.length) && isExpanded && /*#__PURE__*/_react.default.createElement(_fields_list.FieldsList, {
    fields: childFieldsArray,
    treeDepth: treeDepth + 1
  }), renderCreateField());
}
const FieldsListItem = /*#__PURE__*/_react.default.memo( /*#__PURE__*/(0, _react.forwardRef)(FieldListItemComponent));
exports.FieldsListItem = FieldsListItem;