"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageButton = ({
  actions,
  componentTemplateDetails
}) => {
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const items = actions.map(({
    name,
    icon,
    getIsDisabled,
    closePopoverOnClick,
    handleActionClick
  }) => {
    const isDisabled = getIsDisabled ? getIsDisabled(componentTemplateDetails) : false;
    return {
      name,
      icon,
      disabled: isDisabled,
      toolTipContent: isDisabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateDetails.manageButtonDisabledTooltipLabel",
        defaultMessage: "Template is in use and cannot be deleted"
      }) : null,
      onClick: () => {
        handleActionClick();
        if (closePopoverOnClick) {
          setIsPopOverOpen(false);
        }
      },
      'data-test-subj': 'action'
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "manageComponentTemplatePanel",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "manageComponentTemplateButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsPopOverOpen(prevBoolean => !prevBoolean)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateDetails.manageButtonLabel",
      defaultMessage: "Manage"
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopOverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "rightUp",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    "data-test-subj": "manageComponentTemplateContextMenu",
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateDetails.manageContextMenuPanelTitle', {
        defaultMessage: 'Options'
      }),
      items
    }]
  }));
};
exports.ManageButton = ManageButton;