"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListActionHandler = void 0;
var _react = _interopRequireDefault(require("react"));
var _policy_list_context = require("../policy_list_context");
var _index_templates_flyout = require("../../../components/index_templates_flyout");
var _confirm_delete = require("./confirm_delete");
var _add_policy_to_template_confirm_modal = require("./add_policy_to_template_confirm_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListActionHandler = ({
  updatePolicies
}) => {
  const {
    listAction,
    setListAction
  } = (0, _policy_list_context.usePolicyListContext)();
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'viewIndexTemplates') {
    var _listAction$selectedP;
    return /*#__PURE__*/_react.default.createElement(_index_templates_flyout.IndexTemplatesFlyout, {
      policyName: listAction.selectedPolicy.name,
      indexTemplates: (_listAction$selectedP = listAction.selectedPolicy.indexTemplates) !== null && _listAction$selectedP !== void 0 ? _listAction$selectedP : [],
      close: () => {
        setListAction(null);
      }
    });
  }
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'deletePolicy') {
    return /*#__PURE__*/_react.default.createElement(_confirm_delete.ConfirmDelete, {
      policyToDelete: listAction.selectedPolicy,
      callback: () => {
        updatePolicies();
        setListAction(null);
      },
      onCancel: () => {
        setListAction(null);
      }
    });
  }
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'addIndexTemplate') {
    return /*#__PURE__*/_react.default.createElement(_add_policy_to_template_confirm_modal.AddPolicyToTemplateConfirmModal, {
      policy: listAction.selectedPolicy,
      onSuccess: indexTemplate => {
        // update the linked index templates of the selected policy
        listAction.selectedPolicy.indexTemplates = [...(listAction.selectedPolicy.indexTemplates || []), indexTemplate];
        setListAction(null);
      },
      onCancel: () => setListAction(null)
    });
  }
  return null;
};
exports.ListActionHandler = ListActionHandler;