"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPriorityField = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _edit_policy_context = require("../../../edit_policy_context");
var _form = require("../../../form");
var _ = require("../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexPriorityField = ({
  phase
}) => {
  const {
    policy,
    isNewPolicy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const initialToggleValue = (0, _react.useMemo)(() => {
    var _policy$phases$phase, _policy$phases$phase2, _policy$phases$phase3;
    return isNewPolicy ||
    // enable index priority for new policies
    !((_policy$phases$phase = policy.phases[phase]) !== null && _policy$phases$phase !== void 0 && _policy$phases$phase.actions) ||
    // enable index priority for new phases
    ((_policy$phases$phase2 = policy.phases[phase]) === null || _policy$phases$phase2 === void 0 ? void 0 : (_policy$phases$phase3 = _policy$phases$phase2.actions) === null || _policy$phases$phase3 === void 0 ? void 0 : _policy$phases$phase3.set_priority) != null // enable index priority if it's set
    ;
  }, [isNewPolicy, policy.phases, phase]);
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.indexPriorityText",
      defaultMessage: "Index priority"
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.warmPhase.indexPriorityExplanationText",
      defaultMessage: "Set the priority for recovering your indices after a node restart. Indices with higher priorities are recovered before indices with lower priorities."
    }), ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      docPath: docLinks.links.elasticsearch.ilmSetPriority
    })),
    titleSize: "xs",
    fullWidth: true,
    switchProps: {
      label: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.indexPriority.indexPriorityEnabledFieldLabel', {
        defaultMessage: 'Set index priority'
      }),
      'data-test-subj': `${phase}-indexPrioritySwitch`,
      initialValue: initialToggleValue
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `phases.${phase}.actions.set_priority.priority`,
    component: _shared_imports.NumericField,
    euiFieldProps: {
      fullWidth: false,
      'data-test-subj': `${phase}-indexPriority`,
      min: 0
    }
  }));
};
exports.IndexPriorityField = IndexPriorityField;