"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logsTSDBSpecProvider = exports.GLOBE_ICON_PATH = void 0;
var _path = _interopRequireDefault(require("path"));
var _i18n = require("@kbn/i18n");
var _saved_objects = require("./saved_objects");
var _field_mappings = require("./field_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const logsName = _i18n.i18n.translate('home.sampleData.logsTsdbSpecTitle', {
  defaultMessage: 'Sample web logs (TSDB)'
});
const logsDescription = _i18n.i18n.translate('home.sampleData.logsTsdbSpecDescription', {
  defaultMessage: 'Sample data, visualizations, and dashboards for monitoring web logs.'
});
const GLOBE_ICON_PATH = '/plugins/home/assets/sample_data_resources/logs/icon.svg';
exports.GLOBE_ICON_PATH = GLOBE_ICON_PATH;
const logsTSDBSpecProvider = ({
  staticAssets
}) => {
  const startDate = new Date();
  const endDate = new Date();
  startDate.setMonth(startDate.getMonth() - 1);
  endDate.setMonth(endDate.getMonth() + 2);
  return {
    id: 'logstsdb',
    name: logsName,
    description: logsDescription,
    previewImagePath: staticAssets.getPluginAssetHref('/sample_data_resources/logs/dashboard.webp'),
    darkPreviewImagePath: staticAssets.getPluginAssetHref('/sample_data_resources/logs/dashboard_dark.webp'),
    overviewDashboard: 'edf84fe0-e1a0-11e7-b6d5-4dc382ef8f5b',
    defaultIndex: '90943e30-9a47-11e8-b64d-95841ca0c247',
    savedObjects: (0, _saved_objects.getSavedObjects)(),
    dataIndices: [{
      id: 'logstsdb',
      dataPath: _path.default.join(__dirname, './logs.json.gz'),
      fields: _field_mappings.fieldMappings,
      timeFields: ['@timestamp', 'utc_time'],
      currentTimeMarker: '2018-08-01T00:00:00',
      preserveDayOfWeekTimeOfDay: true,
      indexSettings: {
        number_of_shards: 1,
        auto_expand_replicas: '0-1',
        mode: 'time_series',
        routing_path: 'event.dataset',
        'time_series.start_time': startDate.toISOString(),
        'time_series.end_time': endDate.toISOString()
      }
    }],
    status: 'not_installed',
    iconPath: staticAssets.getPluginAssetHref('/sample_data_resources/logs/icon.svg')
  };
};
exports.logsTSDBSpecProvider = logsTSDBSpecProvider;