"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tutorial = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _footer = require("./footer");
var _introduction = require("./introduction");
var _instruction_set = require("./instruction_set");
var _saved_objects_installer = require("./saved_objects_installer");
var _eui = require("@elastic/eui");
var StatusCheckStates = _interopRequireWildcard(require("./status_check_states"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana_services = require("../../kibana_services");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const INSTRUCTIONS_TYPE = {
  ELASTIC_CLOUD: 'elasticCloud',
  ON_PREM: 'onPrem',
  ON_PREM_ELASTIC_CLOUD: 'onPremElasticCloud'
};
const integrationsTitle = _i18n.i18n.translate('home.breadcrumbs.integrationsAppTitle', {
  defaultMessage: 'Integrations'
});
class TutorialUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getInstructions", () => {
      if (!this.state.tutorial) {
        return {
          instructionSets: []
        };
      }
      switch (this.state.visibleInstructions) {
        case INSTRUCTIONS_TYPE.ELASTIC_CLOUD:
          return this.state.tutorial.elasticCloud;
        case INSTRUCTIONS_TYPE.ON_PREM:
          return this.state.tutorial.onPrem;
        case INSTRUCTIONS_TYPE.ON_PREM_ELASTIC_CLOUD:
          return this.state.tutorial.onPremElasticCloud;
        default:
          throw new Error(this.props.intl.formatMessage({
            id: 'home.tutorial.unhandledInstructionTypeErrorDescription',
            defaultMessage: 'Unhandled instruction type {visibleInstructions}'
          }, {
            visibleInstructions: this.state.visibleInstructions
          }));
      }
    });
    (0, _defineProperty2.default)(this, "getInstructionSets", () => this.getInstructions().instructionSets);
    (0, _defineProperty2.default)(this, "initInstructionsState", () => {
      const instructions = this.getInstructions();
      const paramValues = {};
      if (instructions.params) {
        instructions.params.forEach(param => {
          paramValues[param.id] = param.defaultValue;
        });
      }
      const statusCheckStates = new Array(instructions.instructionSets.length).fill(StatusCheckStates.NOT_CHECKED);
      this.setState({
        paramValues,
        statusCheckStates
      });
    });
    (0, _defineProperty2.default)(this, "setVisibleInstructions", instructionsType => {
      this.setState({
        visibleInstructions: instructionsType
      }, this.initInstructionsState);
    });
    (0, _defineProperty2.default)(this, "setParameter", (paramId, newValue) => {
      this.setState(previousState => {
        const paramValues = _lodash.default.cloneDeep(previousState.paramValues);
        paramValues[paramId] = newValue;
        return {
          paramValues: paramValues
        };
      });
    });
    (0, _defineProperty2.default)(this, "checkInstructionSetStatus", async instructionSetIndex => {
      const instructionSet = this.getInstructionSets()[instructionSetIndex];
      const esHitsCheckConfig = _lodash.default.get(instructionSet, `statusCheck.esHitsCheck`);

      //Checks if a custom status check callback  was registered in the CLIENT
      //that matches the same name registered in the SERVER (customStatusCheckName)
      const customStatusCheckCallback = (0, _kibana_services.getServices)().tutorialService.getCustomStatusCheck(this.state.tutorial.customStatusCheckName);
      const [esHitsStatusCheck, customStatusCheck] = await Promise.all([...(esHitsCheckConfig ? [this.fetchEsHitsStatus(esHitsCheckConfig)] : []), ...(customStatusCheckCallback ? [this.fetchCustomStatusCheck(customStatusCheckCallback)] : [])]);
      const nextStatusCheckState = esHitsStatusCheck === StatusCheckStates.HAS_DATA || customStatusCheck === StatusCheckStates.HAS_DATA ? StatusCheckStates.HAS_DATA : StatusCheckStates.NO_DATA;
      this.setState(prevState => ({
        statusCheckStates: {
          ...prevState.statusCheckStates,
          [instructionSetIndex]: nextStatusCheckState
        }
      }));
    });
    (0, _defineProperty2.default)(this, "fetchCustomStatusCheck", async customStatusCheckCallback => {
      try {
        const response = await customStatusCheckCallback();
        return response ? StatusCheckStates.HAS_DATA : StatusCheckStates.NO_DATA;
      } catch (e) {
        return StatusCheckStates.ERROR;
      }
    });
    /**
     *
     * @param esHitsCheckConfig
     * @return {Promise<string>}
     */
    (0, _defineProperty2.default)(this, "fetchEsHitsStatus", async esHitsCheckConfig => {
      const {
        http
      } = (0, _kibana_services.getServices)();
      try {
        const response = await http.post('/api/home/hits_status', {
          body: JSON.stringify({
            index: esHitsCheckConfig.index,
            query: esHitsCheckConfig.query
          })
        });
        return response.count > 0 ? StatusCheckStates.HAS_DATA : StatusCheckStates.NO_DATA;
      } catch (e) {
        return StatusCheckStates.ERROR;
      }
    });
    (0, _defineProperty2.default)(this, "renderInstructionSetsToggle", () => {
      if (!this.props.isCloudEnabled && this.state.tutorial.onPremElasticCloud) {
        const selfManagedLabel = this.props.intl.formatMessage({
          id: 'home.tutorial.selfManagedButtonLabel',
          defaultMessage: 'Self managed'
        });
        const cloudLabel = this.props.intl.formatMessage({
          id: 'home.tutorial.elasticCloudButtonLabel',
          defaultMessage: 'Elastic Cloud'
        });
        const radioButtons = [{
          id: INSTRUCTIONS_TYPE.ON_PREM,
          label: selfManagedLabel,
          'data-test-subj': 'selfManagedTutorial'
        }, {
          id: INSTRUCTIONS_TYPE.ON_PREM_ELASTIC_CLOUD,
          label: cloudLabel,
          'data-test-subj': 'onCloudTutorial'
        }];
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
          isFullWidth: true,
          buttonSize: "m",
          options: radioButtons,
          idSelected: this.state.visibleInstructions,
          onChange: this.setVisibleInstructions,
          color: "text",
          legend: _i18n.i18n.translate('home.tutorial.selectionLegend', {
            defaultMessage: 'Deployment type'
          })
        })));
      }
    });
    (0, _defineProperty2.default)(this, "onStatusCheck", instructionSetIndex => {
      this.setState(prevState => ({
        statusCheckStates: {
          ...prevState.statusCheckStates,
          [instructionSetIndex]: StatusCheckStates.FETCHING
        }
      }), this.checkInstructionSetStatus.bind(null, instructionSetIndex));
    });
    (0, _defineProperty2.default)(this, "renderInstructionSets", instructions => {
      let offset = 1;
      return instructions.instructionSets.map((instructionSet, index) => {
        const currentOffset = offset;
        offset += instructionSet.instructionVariants[0].instructions.length;
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          key: index
        }, /*#__PURE__*/_react.default.createElement(_instruction_set.InstructionSet, {
          title: instructionSet.title,
          callOut: instructionSet.callOut,
          instructionVariants: instructionSet.instructionVariants,
          statusCheckConfig: instructionSet.statusCheck,
          statusCheckState: this.state.statusCheckStates[index],
          onStatusCheck: () => {
            this.onStatusCheck(index);
          },
          offset: currentOffset,
          params: instructions.params,
          paramValues: this.state.paramValues,
          setParameter: this.setParameter,
          replaceTemplateStrings: this.props.replaceTemplateStrings,
          isCloudEnabled: this.props.isCloudEnabled
        }), index < instructions.instructionSets.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
      });
    });
    (0, _defineProperty2.default)(this, "renderSavedObjectsInstaller", () => {
      if (!this.state.tutorial.savedObjects) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "l"
      }, /*#__PURE__*/_react.default.createElement(_saved_objects_installer.SavedObjectsInstaller, {
        bulkCreate: this.props.bulkCreate,
        savedObjects: this.state.tutorial.savedObjects,
        installMsg: this.state.tutorial.savedObjectsInstallMsg
      })));
    });
    (0, _defineProperty2.default)(this, "renderFooter", () => {
      let label;
      let url;
      if (_lodash.default.has(this.state, 'tutorial.artifacts.application')) {
        label = this.state.tutorial.artifacts.application.label;
        url = this.props.addBasePath(this.state.tutorial.artifacts.application.path);
      } else if (_lodash.default.has(this.state, 'tutorial.artifacts.dashboards')) {
        const overviewDashboard = this.state.tutorial.artifacts.dashboards.find(dashboard => {
          return dashboard.isOverview;
        });
        if (overviewDashboard) {
          label = overviewDashboard.linkLabel;
          url = this.props.addBasePath(`/app/dashboards#/view/${overviewDashboard.id}`);
        }
      }
      if (url && label) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "l"
        }, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
          label: label,
          url: url
        })));
      }
    });
    this.state = {
      notFound: false,
      paramValues: {},
      statusCheckStates: [],
      tutorial: null
    };
    if (props.isCloudEnabled) {
      this.state.visibleInstructions = INSTRUCTIONS_TYPE.ELASTIC_CLOUD;
    } else {
      this.state.visibleInstructions = INSTRUCTIONS_TYPE.ON_PREM;
    }
  }
  UNSAFE_componentWillMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async componentDidMount() {
    const tutorial = await this.props.getTutorial(this.props.tutorialId);
    if (!this._isMounted) {
      return;
    }
    if (tutorial) {
      // eslint-disable-next-line react/no-did-mount-set-state
      this.setState({
        tutorial: tutorial
      }, this.initInstructionsState);
    } else {
      // eslint-disable-next-line react/no-did-mount-set-state
      this.setState({
        notFound: true
      });
    }
    (0, _kibana_services.getServices)().chrome.setBreadcrumbs([{
      text: integrationsTitle,
      href: this.props.addBasePath('/app/integrations/browse')
    }, {
      text: tutorial ? tutorial.name : this.props.tutorialId
    }]);
  }
  renderModuleNotices() {
    const notices = (0, _kibana_services.getServices)().tutorialService.getModuleNotices();
    if (notices.length && this.state.tutorial.moduleName) {
      return notices.map((ModuleNotice, index) => /*#__PURE__*/_react.default.createElement(ModuleNotice, {
        key: index,
        moduleName: this.state.tutorial.moduleName
      }));
    } else {
      return null;
    }
  }
  render() {
    let content;
    if (this.state.notFound) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
        isEmptyState: true,
        pageHeader: {
          iconType: 'faceSad',
          iconProps: {
            color: 'subdued'
          },
          pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "home.tutorial.noTutorialLabel",
            defaultMessage: "Unable to find tutorial {tutorialId}",
            values: {
              tutorialId: this.props.tutorialId
            }
          }),
          rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            href: this.props.addBasePath('/app/home#/tutorial_directory'),
            fill: true,
            iconType: "sortLeft",
            iconSide: "left"
          }, _i18n.i18n.translate('home.tutorial.backToDirectory', {
            defaultMessage: 'Back to directory'
          }))]
        }
      });
    }
    if (this.state.tutorial) {
      let previewUrl;
      if (this.state.tutorial.previewImagePath) {
        previewUrl = this.props.addBasePath(this.state.tutorial.previewImagePath);
      }
      let exportedFieldsUrl;
      if (_lodash.default.has(this.state, 'tutorial.artifacts.exportedFields')) {
        exportedFieldsUrl = this.props.replaceTemplateStrings(this.state.tutorial.artifacts.exportedFields.documentationUrl);
      }
      let icon = this.state.tutorial.euiIconType;
      if (icon && icon.includes('/')) {
        icon = this.props.addBasePath(icon);
      }
      const instructions = this.getInstructions();
      content = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_introduction.Introduction, {
        category: this.state.tutorial.category,
        title: this.state.tutorial.name,
        description: this.props.replaceTemplateStrings(this.state.tutorial.longDescription),
        previewUrl: previewUrl,
        exportedFieldsUrl: exportedFieldsUrl,
        iconType: icon,
        isBeta: this.state.tutorial.isBeta,
        notices: this.renderModuleNotices(),
        basePath: (0, _kibana_services.getServices)().http.basePath
      }), this.renderInstructionSetsToggle(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this.renderInstructionSets(instructions), this.renderSavedObjectsInstaller(), this.renderFooter());
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
      template: "empty"
    }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, content));
  }
}
TutorialUi.propTypes = {
  addBasePath: _propTypes.default.func.isRequired,
  isCloudEnabled: _propTypes.default.bool.isRequired,
  getTutorial: _propTypes.default.func.isRequired,
  replaceTemplateStrings: _propTypes.default.func.isRequired,
  tutorialId: _propTypes.default.string.isRequired,
  bulkCreate: _propTypes.default.func.isRequired
};
const Tutorial = (0, _i18nReact.injectI18n)(TutorialUi);
exports.Tutorial = Tutorial;