"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instruction = Instruction;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _content = require("./content");
var _eui = require("@elastic/eui");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Instruction({
  commands,
  paramValues,
  textPost,
  textPre,
  replaceTemplateStrings,
  customComponentName,
  variantId,
  isCloudEnabled
}) {
  const {
    tutorialService,
    http,
    uiSettings,
    getBasePath,
    kibanaVersion
  } = (0, _kibana_services.getServices)();
  let pre;
  if (textPre) {
    pre = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: replaceTemplateStrings(textPre)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  let post;
  if (textPost) {
    post = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: replaceTemplateStrings(textPost)
    }));
  }
  const customComponent = tutorialService.getCustomComponent(customComponentName);
  //Memoize the custom component so it wont rerender everytime
  const LazyCustomComponent = (0, _react.useMemo)(() => {
    if (customComponent) {
      return /*#__PURE__*/_react.default.lazy(() => customComponent());
    }
  }, [customComponent]);
  let commandBlock;
  if (commands) {
    const cmdText = commands.map(cmd => {
      return replaceTemplateStrings(cmd, paramValues);
    }).join('\n');
    commandBlock = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash"
    }, cmdText);
  }
  return /*#__PURE__*/_react.default.createElement("div", null, pre, commandBlock, LazyCustomComponent && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(LazyCustomComponent, {
    basePath: getBasePath(),
    isDarkTheme: uiSettings.get('theme:darkMode'),
    http: http,
    variantId: variantId,
    isCloudEnabled: isCloudEnabled,
    kibanaVersion: kibanaVersion
  }))), post);
}
Instruction.propTypes = {
  commands: _propTypes.default.array,
  paramValues: _propTypes.default.object.isRequired,
  textPost: _propTypes.default.string,
  textPre: _propTypes.default.string,
  replaceTemplateStrings: _propTypes.default.func.isRequired,
  customComponentName: _propTypes.default.string,
  variantId: _propTypes.default.string,
  isCloudEnabled: _propTypes.default.bool.isRequired
};