"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetConfigRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerGetConfigRoute = (router, guidesConfig) => {
  // Fetch the config of the guide
  router.get({
    path: `${_common.API_BASE_PATH}/configs/{guideId}`,
    validate: {
      params: _configSchema.schema.object({
        guideId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const {
      guideId
    } = request.params;
    if (guidesConfig && guideId && Object.keys(guidesConfig).includes(guideId)) {
      return response.ok({
        body: {
          config: guidesConfig[guideId]
        }
      });
    }
    return response.notFound();
  });
};
exports.registerGetConfigRoute = registerGetConfigRoute;