"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
exports.SearchBarComponent = SearchBarComponent;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _source_modal = require("../services/source_modal");
var _state_management = require("../state_management");
var _tooltip_wrapper = require("./tooltip_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function queryToString(query, indexPattern) {
  if (query.language === 'kuery' && typeof query.query === 'string') {
    const dsl = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query), indexPattern);
    // JSON representation of query will be handled by existing logic.
    // TODO clean this up and handle it in the data fetch layer once
    // it moved to typescript.
    return JSON.stringify(dsl);
  }
  if (typeof query.query === 'string') {
    return query.query;
  }
  return JSON.stringify(query.query);
}
function SearchBarComponent(props) {
  const {
    isLoading,
    urlQuery,
    currentIndexPattern,
    currentDatasource,
    indexPatternProvider,
    selectedFields,
    submit,
    onIndexPatternSelected,
    confirmWipeWorkspace,
    onIndexPatternChange
  } = props;
  const [query, setQuery] = (0, _react.useState)({
    language: 'kuery',
    query: urlQuery || ''
  });
  (0, _react.useEffect)(() => setQuery(prev => ({
    language: prev.language,
    query: urlQuery || ''
  })), [urlQuery]);
  (0, _react.useEffect)(() => {
    async function fetchPattern() {
      if (currentDatasource) {
        onIndexPatternChange(await indexPatternProvider.get(currentDatasource.id));
      } else {
        onIndexPatternChange(undefined);
      }
    }
    fetchPattern();
  }, [currentDatasource, indexPatternProvider, onIndexPatternChange]);
  const kibana = (0, _public.useKibana)();
  const {
    services,
    overlays
  } = kibana;
  const {
    uiSettings,
    appName,
    unifiedSearch,
    data,
    dataViews,
    storage,
    notifications,
    http,
    docLinks,
    contentManagement
  } = services;
  if (!overlays) return null;
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: e => {
      e.preventDefault();
      if (!isLoading && currentIndexPattern) {
        submit(queryToString(query, currentIndexPattern));
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.graph.bar.pickSourceTooltip', {
      defaultMessage: 'Select a data source to begin graphing relationships.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "gphSearchBar__datasourceButton",
    "data-test-subj": "graphDatasourceButton",
    onClick: () => {
      confirmWipeWorkspace(() => (0, _source_modal.openSourceModal)({
        overlays,
        contentManagement,
        uiSettings
      }, onIndexPatternSelected), _i18n.i18n.translate('xpack.graph.clearWorkspace.confirmText', {
        defaultMessage: 'If you change data sources, your current fields and vertices will be reset.'
      }), {
        confirmButtonText: _i18n.i18n.translate('xpack.graph.clearWorkspace.confirmButtonLabel', {
          defaultMessage: 'Change data source'
        }),
        title: _i18n.i18n.translate('xpack.graph.clearWorkspace.modalTitle', {
          defaultMessage: 'Unsaved changes'
        })
      });
    }
  }, currentIndexPattern ? currentIndexPattern.getName() :
  // This branch will be shown if the user exits the
  // initial picker modal
  _i18n.i18n.translate('xpack.graph.bar.pickSourceLabel', {
    defaultMessage: 'Select a data source'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public2.QueryStringInput, {
    timeRangeForSuggestionsOverride: false // to don't filter suggestions by the global time range
    ,
    disableAutoFocus: true,
    bubbleSubmitEvent: true,
    indexPatterns: currentIndexPattern ? [currentIndexPattern] : [],
    placeholder: _i18n.i18n.translate('xpack.graph.bar.searchFieldPlaceholder', {
      defaultMessage: 'Search your data and add to graph'
    }),
    query: query,
    onChange: setQuery,
    appName: appName,
    deps: {
      unifiedSearch,
      data,
      dataViews,
      storage,
      notifications,
      http,
      docLinks,
      uiSettings
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tooltip_wrapper.TooltipWrapper, {
    condition: !currentIndexPattern || !selectedFields.length,
    tooltipContent: !currentIndexPattern ? _i18n.i18n.translate('xpack.graph.bar.exploreLabelNoIndexPattern', {
      defaultMessage: 'Select a data source'
    }) : _i18n.i18n.translate('xpack.graph.bar.exploreLabelNoFields', {
      defaultMessage: 'Select at least one field'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    disabled: isLoading || !currentIndexPattern || !selectedFields.length,
    "data-test-subj": "graph-explore-button"
  }, _i18n.i18n.translate('xpack.graph.bar.exploreLabel', {
    defaultMessage: 'Graph'
  }))))));
}
const SearchBar = (0, _reactRedux.connect)(state => {
  const datasource = (0, _state_management.datasourceSelector)(state);
  return {
    currentDatasource: datasource.current.type === 'indexpattern' ? datasource.current : undefined,
    selectedFields: (0, _state_management.selectedFieldsSelector)(state)
  };
}, dispatch => ({
  onIndexPatternSelected: indexPattern => {
    dispatch((0, _state_management.requestDatasource)({
      type: 'indexpattern',
      id: indexPattern.id,
      title: indexPattern.attributes.title
    }));
  },
  submit: searchTerm => {
    dispatch((0, _state_management.submitSearch)(searchTerm));
  }
}))(SearchBarComponent);
exports.SearchBar = SearchBar;