"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultPipeline = void 0;
var yaml = _interopRequireWildcard(require("js-yaml"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: The install methods will take care of adding a reference to a @custom pipeline. We don't need to add one here.
const createDefaultPipeline = (dataset, type) => {
  const pipeline = {
    processors: [{
      set: {
        description: "If '@timestamp' is missing, set it with the ingest timestamp",
        field: '@timestamp',
        override: false,
        copy_from: '_ingest.timestamp'
      }
    }],
    _meta: {
      description: `default pipeline for the ${dataset} dataset`,
      managed: true
    }
  };
  return yaml.dump(pipeline);
};
exports.createDefaultPipeline = createDefaultPipeline;