"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classPrivateMethodGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateMethodGet"));
var _http_authorization_header = require("../../../common/http_authorization_header");
var _security = require("../security");
var _errors = require("../../errors");
var _epm = require("../../routes/epm");
var _install = require("./elasticsearch/transform/install");
var _registry = require("./registry");
var _packages = require("./packages");
var _archive = require("./archive");
function _classPrivateMethodInitSpec(obj, privateSet) { _checkPrivateRedeclaration(obj, privateSet); privateSet.add(obj); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } } /*
                                                                                                                                                                                            * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                            * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                            * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                            * 2.0.
                                                                                                                                                                                            */ /* eslint-disable max-classes-per-file */
class PackageServiceImpl {
  constructor(internalEsClient, internalSoClient, logger) {
    this.internalEsClient = internalEsClient;
    this.internalSoClient = internalSoClient;
    this.logger = logger;
  }
  asScoped(request) {
    const preflightCheck = async requiredAuthz => {
      if (requiredAuthz) {
        const requestedAuthz = await (0, _security.getAuthzFromRequest)(request);
        const noRequiredAuthz = (0, _security.doesNotHaveRequiredFleetAuthz)(requestedAuthz, requiredAuthz);
        if (noRequiredAuthz) {
          throw new _errors.FleetUnauthorizedError(`User does not have adequate permissions to access Fleet packages.`);
        }
      } else if (!(0, _security.checkSuperuser)(request)) {
        throw new _errors.FleetUnauthorizedError(`User does not have adequate permissions to access Fleet packages.`);
      }
    };
    return new PackageClientImpl(this.internalEsClient, this.internalSoClient, this.logger, preflightCheck, request);
  }
  get asInternalUser() {
    return new PackageClientImpl(this.internalEsClient, this.internalSoClient, this.logger);
  }
}
exports.PackageServiceImpl = PackageServiceImpl;
var _reinstallTransforms = /*#__PURE__*/new WeakSet();
var _runPreflight = /*#__PURE__*/new WeakSet();
class PackageClientImpl {
  constructor(internalEsClient, internalSoClient, logger, preflightCheck, request) {
    _classPrivateMethodInitSpec(this, _runPreflight);
    _classPrivateMethodInitSpec(this, _reinstallTransforms);
    (0, _defineProperty2.default)(this, "authorizationHeader", undefined);
    this.internalEsClient = internalEsClient;
    this.internalSoClient = internalSoClient;
    this.logger = logger;
    this.preflightCheck = preflightCheck;
    this.request = request;
  }
  getAuthorizationHeader() {
    if (this.request) {
      this.authorizationHeader = _http_authorization_header.HTTPAuthorizationHeader.parseFromRequest(this.request);
      return this.authorizationHeader;
    }
  }
  async getInstallation(pkgName) {
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _packages.getInstallation)({
      pkgName,
      savedObjectsClient: this.internalSoClient
    });
  }
  async ensureInstalledPackage(options) {
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.INSTALL_PACKAGES_AUTHZ);
    return (0, _packages.ensureInstalledPackage)({
      ...options,
      esClient: this.internalEsClient,
      savedObjectsClient: this.internalSoClient
    });
  }
  async fetchFindLatestPackage(packageName, options) {
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _registry.fetchFindLatestPackageOrThrow)(packageName, options);
  }
  async readBundledPackage(bundledPackage) {
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    const archiveBuffer = await bundledPackage.getBuffer();
    return (0, _archive.generatePackageInfoFromArchiveBuffer)(archiveBuffer, 'application/zip');
  }
  async getPackage(packageName, packageVersion, options) {
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _registry.getPackage)(packageName, packageVersion, options);
  }
  async getPackages(params) {
    const {
      excludeInstallStatus,
      category,
      prerelease
    } = params || {};
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _packages.getPackages)({
      savedObjectsClient: this.internalSoClient,
      excludeInstallStatus,
      category,
      prerelease
    });
  }
  async reinstallEsAssets(packageInfo, assetPaths) {
    await (0, _classPrivateMethodGet2.default)(this, _runPreflight, _runPreflight2).call(this, _epm.INSTALL_PACKAGES_AUTHZ);
    let installedAssets = [];
    const transformPaths = assetPaths.filter(_install.isTransform);
    if (transformPaths.length !== assetPaths.length) {
      throw new _errors.FleetError('reinstallEsAssets is currently only implemented for transform assets');
    }
    if (transformPaths.length) {
      const installedTransformAssets = await (0, _classPrivateMethodGet2.default)(this, _reinstallTransforms, _reinstallTransforms2).call(this, packageInfo, transformPaths);
      installedAssets = [...installedAssets, ...installedTransformAssets];
    }
    return installedAssets;
  }
}
async function _reinstallTransforms2(packageInfo, paths) {
  const authorizationHeader = this.getAuthorizationHeader();
  const {
    installedTransforms
  } = await (0, _install.installTransforms)({
    installablePackage: packageInfo,
    paths,
    esClient: this.internalEsClient,
    savedObjectsClient: this.internalSoClient,
    logger: this.logger,
    force: true,
    esReferences: undefined,
    authorizationHeader
  });
  return installedTransforms;
}
async function _runPreflight2(requiredAuthz) {
  if (this.preflightCheck) {
    return await this.preflightCheck(requiredAuthz);
  }
}