"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentServiceImpl = void 0;
var _classPrivateFieldGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldGet"));
var _security = require("../security");
var _errors = require("../../errors");
var _crud = require("./crud");
var _status = require("./status");
var _versions = require("./versions");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } } /*
                                                                                                                                                                                            * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                            * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                            * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                            * 2.0.
                                                                                                                                                                                            */ /* eslint-disable max-classes-per-file */
/**
 * A service for interacting with Agent data. See {@link AgentClient} for more information.
 *
 * @public
 */
/**
 * A client for interacting with data about an Agent
 *
 * @public
 */
var _runPreflight = /*#__PURE__*/new WeakMap();
/**
 * @internal
 */
class AgentClientImpl {
  constructor(internalEsClient, soClient, preflightCheck) {
    _classPrivateFieldInitSpec(this, _runPreflight, {
      writable: true,
      value: async () => {
        if (this.preflightCheck) {
          return this.preflightCheck();
        }
      }
    });
    this.internalEsClient = internalEsClient;
    this.soClient = soClient;
    this.preflightCheck = preflightCheck;
  }
  async listAgents(options) {
    await (0, _classPrivateFieldGet2.default)(this, _runPreflight).call(this);
    return (0, _crud.getAgentsByKuery)(this.internalEsClient, this.soClient, options);
  }
  async getAgent(agentId) {
    await (0, _classPrivateFieldGet2.default)(this, _runPreflight).call(this);
    return (0, _crud.getAgentById)(this.internalEsClient, this.soClient, agentId);
  }
  async getAgentStatusById(agentId) {
    await (0, _classPrivateFieldGet2.default)(this, _runPreflight).call(this);
    return (0, _status.getAgentStatusById)(this.internalEsClient, this.soClient, agentId);
  }
  async getAgentStatusForAgentPolicy(agentPolicyId, filterKuery) {
    await (0, _classPrivateFieldGet2.default)(this, _runPreflight).call(this);
    return (0, _status.getAgentStatusForAgentPolicy)(this.internalEsClient, this.soClient, agentPolicyId, filterKuery);
  }
  async getLatestAgentAvailableVersion(includeCurrentVersion) {
    await (0, _classPrivateFieldGet2.default)(this, _runPreflight).call(this);
    return (0, _versions.getLatestAvailableVersion)(includeCurrentVersion);
  }
}

/**
 * @internal
 */
class AgentServiceImpl {
  constructor(internalEsClient, soClient) {
    this.internalEsClient = internalEsClient;
    this.soClient = soClient;
  }
  asScoped(req) {
    const preflightCheck = async () => {
      const authz = await (0, _security.getAuthzFromRequest)(req);
      if (!authz.fleet.all) {
        throw new _errors.FleetUnauthorizedError(`User does not have adequate permissions to access Fleet agents.`);
      }
    };
    return new AgentClientImpl(this.internalEsClient, this.soClient, preflightCheck);
  }
  get asInternalUser() {
    return new AgentClientImpl(this.internalEsClient, this.soClient);
  }
}
exports.AgentServiceImpl = AgentServiceImpl;