"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.get({
    path: _constants2.OUTPUT_API_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOutputsRequestSchema
    }
  }, _handler.getOutputsHandler);
  router.versioned.get({
    path: _constants2.OUTPUT_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneOutputRequestSchema
    }
  }, _handler.getOneOuputHandler);
  router.versioned.put({
    path: _constants2.OUTPUT_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutOutputRequestSchema
    }
  }, _handler.putOutputHandler);
  router.versioned.post({
    path: _constants2.OUTPUT_API_ROUTES.CREATE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostOutputRequestSchema
    }
  }, _handler.postOutputHandler);
  router.versioned.delete({
    path: _constants2.OUTPUT_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteOutputRequestSchema
    }
  }, _handler.deleteOutputHandler);
  router.versioned.post({
    path: _constants2.OUTPUT_API_ROUTES.LOGSTASH_API_KEY_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handler.postLogstashApiKeyHandler);
  router.versioned.get({
    path: _constants2.OUTPUT_API_ROUTES.GET_OUTPUT_HEALTH_PATTERN,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetLatestOutputHealthRequestSchema
    }
  }, _handler.getLatestOutputHealth);
};
exports.registerRoutes = registerRoutes;