"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _epm = require("../../common/constants/epm");
var _hooks = require("../hooks");
var _kubernetes_instructions = require("./agent_enrollment_flyout/kubernetes_instructions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Otherwise the copy button is over the text
const CommandCode = _styledComponents.default.pre({
  overflow: 'auto'
});
const PlatformSelector = ({
  linuxCommand,
  macCommand,
  windowsCommand,
  linuxDebCommand,
  linuxRpmCommand,
  k8sCommand,
  hasK8sIntegration,
  cloudSecurityIntegration,
  hasK8sIntegrationMultiPage,
  isManaged,
  enrollToken,
  hasFleetServer,
  fleetServerHost,
  fullCopyButton,
  onCopy
}) => {
  const getInitialPlatform = (0, _react.useCallback)(() => {
    if (hasK8sIntegration || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE && isManaged) return 'kubernetes';
    return 'linux';
  }, [hasK8sIntegration, cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType, isManaged]);
  const {
    platform,
    setPlatform
  } = (0, _hooks.usePlatform)(getInitialPlatform());

  // In case of fleet server installation or standalone agent without
  // Kubernetes integration in the policy use reduced platform options
  // If it has Cloud Shell URL, then it should show platform options with Cloudshell in it
  const isReduced = hasFleetServer || !isManaged && !hasK8sIntegration;
  const getPlatformOptions = (0, _react.useCallback)(() => {
    const platformOptions = isReduced ? _hooks.REDUCED_PLATFORM_OPTIONS : _hooks.PLATFORM_OPTIONS;
    return platformOptions;
  }, [isReduced]);
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  const systemPackageCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.callout', {
      defaultMessage: 'We recommend using the installers (TAR/ZIP) over system packages (RPM/DEB) because they provide the ability to upgrade your agent with Fleet.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const k8sCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.k8sCallout', {
      defaultMessage: 'We recommend adding the Kubernetes integration to your agent policy in order to get useful metrics and logs from your Kubernetes clusters.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const k8sCSPMCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.placeHolderCallout', {
      defaultMessage: 'We strongly advise against deploying CSPM within a Kubernetes cluster. Doing so may lead to redundant data fetching, which can cause increased consumption costs within your Elastic account and potentially trigger API rate limiting in your cloud account(s).'
    }),
    color: "warning",
    iconType: "warning"
  });
  const macCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.macCallout', {
      defaultMessage: 'We recommend against deploying this integration within Mac as it is currently not being supported.'
    }),
    color: "warning",
    iconType: "warning"
  });
  const commandsByPlatform = {
    linux: linuxCommand,
    mac: macCommand,
    windows: windowsCommand,
    deb: linuxDebCommand,
    rpm: linuxRpmCommand,
    kubernetes: k8sCommand
  };
  const onTextAreaClick = () => {
    if (onCopy) onCopy();
  };
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    options: getPlatformOptions(),
    idSelected: platform,
    onChange: id => setPlatform(id),
    legend: _i18n.i18n.translate('xpack.fleet.enrollmentInstructions.platformSelectAriaLabel', {
      defaultMessage: 'Platform'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (platform === 'deb' || platform === 'rpm') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, systemPackageCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'mac' && ((cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE || (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, macCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && (cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.integrationType) === _epm.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCSPMCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && !hasK8sIntegration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), platform === 'kubernetes' && isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_kubernetes_instructions.KubernetesInstructions, {
    onCopy: onCopy,
    onDownload: onCopy,
    enrollmentAPIKey: enrollToken,
    fleetServerHost: fleetServerHost
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), !hasK8sIntegrationMultiPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, platform === 'kubernetes' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.kubernetesCommandInstructions",
    defaultMessage: "From the directory where the manifest is downloaded, run the apply command."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    onClick: onTextAreaClick,
    fontSize: "m",
    isCopyable: !fullCopyButton,
    paddingSize: "m",
    css: `
                max-width: 1100px;
              `
  }, /*#__PURE__*/_react.default.createElement(CommandCode, null, commandsByPlatform[platform])), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), fullCopyButton && /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: commandsByPlatform[platform]
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "copyClipboard",
    size: "m",
    onClick: () => onCopyButtonClick(copy)
  }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButtonClicked",
    defaultMessage: "Copied"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyButton",
    defaultMessage: "Copy to clipboard"
  }))))));
};
exports.PlatformSelector = PlatformSelector;