"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentEnrollmentKeySelectionStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _advanced_agent_authentication_settings = require("../advanced_agent_authentication_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentEnrollmentKeySelectionStep = ({
  selectedPolicy,
  selectedApiKeyId,
  setSelectedAPIKeyId
}) => {
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfigurePolicyAuthenticationTitle', {
      defaultMessage: 'Select enrollment token'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.agentAuthenticationSettings",
      defaultMessage: "{agentPolicyName} has been selected. Select which enrollment token to use when enrolling agents.",
      values: {
        agentPolicyName: /*#__PURE__*/_react.default.createElement("strong", null, selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.name)
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_advanced_agent_authentication_settings.AdvancedAgentAuthenticationSettings, {
      agentPolicyId: selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.id,
      selectedApiKeyId: selectedApiKeyId,
      initialAuthenticationSettingsOpen: true,
      onKeyChange: setSelectedAPIKeyId
    }))
  };
};
exports.AgentEnrollmentKeySelectionStep = AgentEnrollmentKeySelectionStep;