"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _confirm_package_uninstall = require("./confirm_package_uninstall");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UninstallButton = ({
  disabled = false,
  latestVersion,
  name,
  numOfAssets,
  title,
  version
}) => {
  const canRemovePackages = (0, _hooks.useAuthz)().integrations.removePackages;
  const uninstallPackage = (0, _hooks.useUninstallPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(name);
  const isRemoving = installationStatus === _types.InstallStatus.uninstalling;
  const [isUninstallModalVisible, setIsUninstallModalVisible] = (0, _react.useState)(false);
  const handleClickUninstall = (0, _react.useCallback)(() => {
    uninstallPackage({
      name,
      version,
      title,
      redirectToVersion: latestVersion !== null && latestVersion !== void 0 ? latestVersion : version
    });
    setIsUninstallModalVisible(false);
  }, [uninstallPackage, name, title, version, latestVersion]);
  const uninstallModal = /*#__PURE__*/_react.default.createElement(_confirm_package_uninstall.ConfirmPackageUninstall
  // this is number of which would be installed
  // deleted includes ingest-pipelines etc so could be larger
  // not sure how to do this at the moment so using same value
  , {
    numOfAssets: numOfAssets,
    packageName: title,
    onCancel: () => setIsUninstallModalVisible(false),
    onConfirm: handleClickUninstall
  });
  return canRemovePackages ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "uninstallAssetsButton",
    iconType: 'trash',
    isLoading: isRemoving,
    onClick: () => setIsUninstallModalVisible(true),
    color: "danger",
    disabled: disabled || isRemoving ? true : false
  }, isRemoving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.uninstallPackage.uninstallingPackageButtonLabel",
    defaultMessage: "Uninstalling {title}",
    values: {
      title
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.uninstallPackage.uninstallPackageButtonLabel",
    defaultMessage: "Uninstall {title}",
    values: {
      title
    }
  })), isUninstallModalVisible && uninstallModal) : null;
};
exports.UninstallButton = UninstallButton;