"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReinstallButton = ReinstallButton;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ReinstallButton(props) {
  const {
    name,
    title,
    version,
    installSource
  } = props;
  const canInstallPackages = (0, _hooks.useAuthz)().integrations.installPackages;
  const installPackage = (0, _hooks.useInstallPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(name);
  const isReinstalling = installationStatus === _types.InstallStatus.reinstalling;
  const isUploadedPackage = installSource === 'upload';
  const handleClickReinstall = (0, _react.useCallback)(() => {
    installPackage({
      name,
      version,
      title,
      isReinstall: true
    });
  }, [installPackage, name, title, version]);
  const reinstallButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    isLoading: isReinstalling,
    onClick: handleClickReinstall,
    disabled: isUploadedPackage
  }, isReinstalling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.reinstallingPackageButtonLabel",
    defaultMessage: "Reinstalling {title}",
    values: {
      title
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.installPackage.reinstallPackageButtonLabel",
    defaultMessage: "Reinstall {title}",
    values: {
      title
    }
  }));
  return canInstallPackages ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isUploadedPackage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.installPackage.uploadedTooltip",
      defaultMessage: "This integration was installed by upload and cannot be automatically reinstalled. Please upload it again to reinstall."
    })
  }, reinstallButton) : reinstallButton) : null;
}