"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfirmForceInstall = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../fleet/hooks");
var _components = require("../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const confirmForceInstall = ({
  pkg,
  overlays,
  docLinks
}) => new Promise(resolve => {
  const session = overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ConfirmForceInstallModal, {
    pkg: pkg,
    onConfirm: () => {
      session.close();
      resolve(true);
    },
    onCancel: () => {
      session.close();
      resolve(false);
    },
    docLinks: docLinks
  })));
});
const useConfirmForceInstall = () => {
  const {
    overlays,
    docLinks
  } = (0, _hooks.useStartServices)();
  return (0, _react.useCallback)(pkg => confirmForceInstall({
    pkg,
    overlays,
    docLinks
  }), [docLinks, overlays]);
};
exports.useConfirmForceInstall = useConfirmForceInstall;