"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentLogs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _constants = require("./constants");
var _agent_logs = require("./agent_logs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentLogs = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy
}) => {
  const stateContainer = (0, _react.useMemo)(() => (0, _public.createStateContainer)({
    ..._constants.DEFAULT_LOGS_STATE,
    ...(0, _public.getStateFromKbnUrl)(_constants.STATE_STORAGE_KEY, window.location.href, {
      getFromHashQuery: false
    })
  }, {
    update: state => updatedState => ({
      ...state,
      ...updatedState
    })
  }), []);
  const AgentLogsConnected = (0, _react.useMemo)(() => _agent_logs.AgentLogsUrlStateHelper.connect(state => ({
    state: state || _constants.DEFAULT_LOGS_STATE
  }))(_agent_logs.AgentLogsUI), []);
  const [isSyncReady, setIsSyncReady] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const stateStorage = (0, _public.createKbnUrlStateStorage)({
      useHashQuery: false,
      useHash: false
    });
    const {
      start,
      stop
    } = (0, _public.syncState)({
      storageKey: _constants.STATE_STORAGE_KEY,
      stateContainer: stateContainer,
      stateStorage
    });
    start();
    setIsSyncReady(true);
    return () => {
      stop();
      stateContainer.set(_constants.DEFAULT_LOGS_STATE);
    };
  }, [stateContainer]);
  return /*#__PURE__*/_react.default.createElement(_agent_logs.AgentLogsUrlStateHelper.Provider, {
    value: stateContainer
  }, isSyncReady ? /*#__PURE__*/_react.default.createElement(AgentLogsConnected, {
    agent: agent,
    agentPolicy: agentPolicy
  }) : null);
});
exports.AgentLogs = AgentLogs;