"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsIntegrations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _agent_details_integration = require("./agent_details_integration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentDetailsIntegrations = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy
}) => {
  if (!agentPolicy || !agentPolicy.package_policies) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, agentPolicy.package_policies.map((packagePolicy, index) => {
    var _packagePolicy$packag, _packagePolicy$packag2;
    const testSubj = ((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : 'packagePolicy') + '-' + index;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: packagePolicy.id,
      "data-test-subj": testSubj
    }, /*#__PURE__*/_react.default.createElement(_agent_details_integration.AgentDetailsIntegration, {
      agent: agent,
      agentPolicy: agentPolicy,
      packagePolicy: packagePolicy,
      "data-test-subj": `${testSubj}-accordion`
    }));
  }));
});
exports.AgentDetailsIntegrations = AgentDetailsIntegrations;