"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsIntegration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../../hooks");
var _components = require("../../../../../components");
var _agent_details_integration_inputs = require("./agent_details_integration_inputs");
var _input_status_utils = require("./input_status_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .euiAccordion__button {
    width: 90%;
  }

  .euiAccordion__triggerWrapper {
    padding-left: ${props => props.theme.eui.euiSizeM};
  }

  &.euiAccordion-isOpen {
    .euiAccordion__childWrapper {
      padding: ${props => props.theme.eui.euiSizeM};
      padding-top: 0px;
    }
  }

  .ingest-integration-title-button {
    padding: ${props => props.theme.eui.euiSizeS};
  }

  .euiTableRow:last-child .euiTableRowCell {
    border-bottom: none;
  }

  .euiIEFlexWrapFix {
    min-width: 0;
  }

  .euiAccordion__buttonContent {
    width: 100%;
  }
`;
const CollapsablePanel = ({
  id,
  title,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const arrowProps = (0, _react.useMemo)(() => {
    if (dataTestSubj) {
      return {
        'data-test-subj': `${dataTestSubj}-openCloseToggle`
      };
    }
    return undefined;
  }, [dataTestSubj]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: id,
    arrowDisplay: "left",
    buttonClassName: "ingest-integration-title-button",
    buttonContent: title,
    arrowProps: arrowProps,
    "data-test-subj": dataTestSubj
  }, children));
};
const AgentDetailsIntegration = /*#__PURE__*/(0, _react.memo)(({
  agent,
  agentPolicy,
  packagePolicy,
  'data-test-subj': dataTestSubj
}) => {
  var _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4;
  const {
    getHref
  } = (0, _hooks.useLink)();
  const theme = (0, _eui.useEuiTheme)();
  const [isAttentionBadgeNeededForPolicyResponse, setIsAttentionBadgeNeededForPolicyResponse] = (0, _react.useState)(false);
  const policyResponseExtensionView = (0, _hooks.useUIExtension)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', 'package-policy-response');
  const policyResponseExtensionViewWrapper = (0, _react.useMemo)(() => {
    return policyResponseExtensionView && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(policyResponseExtensionView.Component, {
      agent: agent,
      onShowNeedsAttentionBadge: setIsAttentionBadgeNeededForPolicyResponse
    }));
  }, [agent, policyResponseExtensionView]);
  const packageErrors = (0, _react.useMemo)(() => {
    if (!agent.components) {
      return [];
    }
    return (0, _input_status_utils.getInputUnitsByPackage)(agent.components, packagePolicy).filter(u => u.status === 'DEGRADED' || u.status === 'FAILED');
  }, [agent.components, packagePolicy]);
  const showNeedsAttentionBadge = isAttentionBadgeNeededForPolicyResponse || !!packageErrors.length;
  const genericErrorsListExtensionView = (0, _hooks.useUIExtension)((_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '', 'package-generic-errors-list');
  const genericErrorsListExtensionViewWrapper = (0, _react.useMemo)(() => {
    return genericErrorsListExtensionView && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(genericErrorsListExtensionView.Component, {
      packageErrors: packageErrors
    }));
  }, [packageErrors, genericErrorsListExtensionView]);
  return /*#__PURE__*/_react.default.createElement(CollapsablePanel, {
    id: packagePolicy.id,
    "data-test-subj": dataTestSubj,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, packagePolicy.package ? /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
      packageName: packagePolicy.package.name,
      version: packagePolicy.package.version,
      size: "l",
      tryApi: true
    }) : /*#__PURE__*/_react.default.createElement(_components.PackageIcon, {
      size: "l",
      packageName: "default",
      version: "0"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: "eui-textTruncate",
      "data-test-subj": "agentPolicyDetailsLink",
      href: getHref('edit_integration', {
        policyId: agentPolicy.id,
        packagePolicyId: packagePolicy.id
      })
    }, packagePolicy.name)), showNeedsAttentionBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: theme.euiTheme.colors.danger,
      iconType: "warning",
      iconSide: "left",
      "data-test-subj": dataTestSubj ? `${dataTestSubj}-needsAttention` : undefined
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetailsIntegrations.needsAttention.label",
      defaultMessage: "Needs attention"
    }))))))
  }, /*#__PURE__*/_react.default.createElement(_agent_details_integration_inputs.AgentDetailsIntegrationInputs, {
    agent: agent,
    packagePolicy: packagePolicy
  }), policyResponseExtensionViewWrapper, genericErrorsListExtensionViewWrapper, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
});
exports.AgentDetailsIntegration = AgentDetailsIntegration;