"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyYamlFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _jsYaml = require("js-yaml");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _services = require("../../../services");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    padding: 0;
  }
`;
const AgentPolicyYamlFlyout = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  onClose
}) => {
  var _agentPolicyData$item, _agentPolicyData$item2;
  const core = (0, _hooks.useStartServices)();
  const {
    isLoading: isLoadingYaml,
    data: yamlData,
    error
  } = (0, _hooks.useGetOneAgentPolicyFull)(policyId);
  const {
    data: agentPolicyData
  } = (0, _hooks.useGetOneAgentPolicy)(policyId);
  const packagePoliciesContainSecrets = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : (_agentPolicyData$item = agentPolicyData.item) === null || _agentPolicyData$item === void 0 ? void 0 : (_agentPolicyData$item2 = _agentPolicyData$item.package_policies) === null || _agentPolicyData$item2 === void 0 ? void 0 : _agentPolicyData$item2.some(packagePolicy => {
    var _packagePolicy$secret;
    return packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$secret = packagePolicy.secret_references) === null || _packagePolicy$secret === void 0 ? void 0 : _packagePolicy$secret.length;
  });
  const body = isLoadingYaml ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetails.ErrorGettingFullAgentPolicy",
      defaultMessage: "Error loading agent policy"
    }),
    color: "danger",
    iconType: "warning"
  }, error.message) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    fontSize: "m",
    whiteSpace: "pre"
  }, (0, _services.fullAgentPolicyToYaml)(yamlData.item, _jsYaml.safeDump)));
  const downloadLink = core.http.basePath.prepend(_services.agentPolicyRouteService.getInfoFullDownloadPath(policyId)) + `?apiVersion=${_constants.API_VERSIONS.public.v1}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "l",
    maxWidth: 640
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": "IngestManagerAgentPolicyYamlFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "IngestManagerAgentPolicyYamlFlyoutTitle"
  }, agentPolicyData !== null && agentPolicyData !== void 0 && agentPolicyData.item ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlflyoutTitleWithName",
    defaultMessage: "'{name}' agent policy",
    values: {
      name: agentPolicyData.item.name
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlflyoutTitleWithoutName",
    defaultMessage: "Agent policy"
  }))), packagePoliciesContainSecrets && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetails.secretsTitle",
      defaultMessage: "This policy contains secret values"
    }),
    size: "m",
    color: "primary",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.secretsDescription",
    defaultMessage: "Kibana does not have access to secret values. You will need to set these values manually after deploying the agent policy. Look out for environment variables in the format {envVarPrefix} in the agent configuration.",
    values: {
      envVarPrefix: /*#__PURE__*/_react.default.createElement("code", null, '${SECRET_0}')
    }
  })))), /*#__PURE__*/_react.default.createElement(FlyoutBody, null, body), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlFlyoutCloseButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: downloadLink,
    iconType: "download",
    isDisabled: Boolean(isLoadingYaml && !yamlData)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlDownloadButtonLabel",
    defaultMessage: "Download policy"
  }))))));
});
exports.AgentPolicyYamlFlyout = AgentPolicyYamlFlyout;