"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentPolicyFormValidation = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentPolicyFormValidation = agentPolicy => {
  var _agentPolicy$name;
  const errors = {};
  const namespaceValidation = (0, _services.isValidNamespace)(agentPolicy.namespace || '');
  if (!((_agentPolicy$name = agentPolicy.name) !== null && _agentPolicy$name !== void 0 && _agentPolicy$name.trim())) {
    errors.name = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.nameRequiredErrorMessage",
      defaultMessage: "Agent policy name is required"
    })];
  }
  if (!namespaceValidation.valid && namespaceValidation.error) {
    errors.namespace = [namespaceValidation.error];
  }
  if (agentPolicy.unenroll_timeout && agentPolicy.unenroll_timeout < 0) {
    errors.unenroll_timeout = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.unenrollTimeoutMinValueErrorMessage",
      defaultMessage: "Unenroll timeout must be greater than zero."
    })];
  }
  if (agentPolicy.inactivity_timeout && agentPolicy.inactivity_timeout < 0) {
    errors.inactivity_timeout = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.inactivityTimeoutMinValueErrorMessage",
      defaultMessage: "Inactivity timeout must be greater than zero."
    })];
  }
  return errors;
};
exports.agentPolicyFormValidation = agentPolicyFormValidation;