"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerFlyout = exports.AddFleetServerLanding = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../hooks");
var _quick_start_tab = require("./quick_start_tab");
var _advanced_tab = require("./advanced_tab");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
  margin: 0 auto;
`;
const useFleetServerTabs = onClose => {
  const [currentTab, setCurrentTab] = (0, _react.useState)('quickStart');
  const quickStartTab = {
    id: 'quickStart',
    label: 'Quick Start',
    content: /*#__PURE__*/_react.default.createElement(_quick_start_tab.QuickStartTab, {
      onClose: onClose
    }),
    'data-test-subj': 'fleetServerFlyoutTab-quickStart'
  };
  const advancedTab = {
    id: 'advanced',
    label: 'Advanced',
    content: /*#__PURE__*/_react.default.createElement(_advanced_tab.AdvancedTab, {
      onClose: onClose
    }),
    'data-test-subj': 'fleetServerFlyoutTab-advanced'
  };
  const currentTabContent = currentTab === 'quickStart' ? quickStartTab.content : advancedTab.content;
  return {
    tabs: [quickStartTab, advancedTab],
    currentTab,
    setCurrentTab,
    currentTabContent
  };
};
const Header = ({
  isFlyout = false,
  currentTab: currentTabId,
  tabs,
  onTabClick
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "addFleetServerHeader"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.title",
    defaultMessage: "Add a Fleet Server"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.instructions",
    defaultMessage: "A Fleet Server is required before you can enroll agents with Fleet. Follow the instructions below to set up a Fleet Server. For more information, see the {userGuideLink}",
    values: {
      userGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.fleetServerAddFleetServer,
        external: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerSetup.setupGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "Fleet Server instructions",
    isFullWidth: true,
    options: tabs,
    idSelected: currentTabId,
    onChange: id => onTabClick(id),
    style: {
      maxWidth: '500px'
    }
  }));
};

// Renders instructions inside of a flyout
const FleetServerFlyout = ({
  onClose
}) => {
  const {
    tabs,
    currentTab,
    setCurrentTab,
    currentTabContent
  } = useFleetServerTabs(onClose);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "fleetServerFlyout",
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": "FleetAddFleetServerFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(Header, {
    tabs: tabs,
    currentTab: currentTab,
    onTabClick: id => setCurrentTab(id),
    isFlyout: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, currentTabContent));
};
exports.FleetServerFlyout = FleetServerFlyout;
const AddFleetServerLanding = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const flyoutContext = (0, _hooks.useFlyoutContext)();
  const onClickAddFleetServer = (0, _react.useCallback)(() => {
    flyoutContext.openFleetServerFlyout();
  }, [flyoutContext]);
  return /*#__PURE__*/_react.default.createElement(ContentWrapper, {
    gutterSize: "none",
    justifyContent: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "addFleetServerHeader"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerLanding.title",
    defaultMessage: "Add a Fleet Server"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: `
              max-width: 500px;
              text-align: center;
            `
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerLanding.instructions",
    defaultMessage: "A Fleet Server is required before you can enroll agents with Fleet. Follow the instructions below to set up a Fleet Server. For more information, see the {userGuideLink}",
    values: {
      userGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.fleetServerAddFleetServer,
        external: true,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleetServerSetup.setupGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerLanding.addFleetServerButton.tooltip",
      defaultMessage: "Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClickAddFleetServer,
    fill: true,
    "data-test-subj": "fleetServerLanding.addFleetServerButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerLanding.addFleetServerButton",
    defaultMessage: "Add Fleet Server"
  }))))));
};
exports.AddFleetServerLanding = AddFleetServerLanding;