"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileUploadPlugin = void 0;
var _api = require("./api");
var _kibana_services = require("./kibana_services");
var _get_max_bytes = require("./importer/get_max_bytes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class FileUploadPlugin {
  setup() {}
  start(core, plugins) {
    (0, _kibana_services.setStartServices)(core, plugins);
    return {
      FileUploadComponent: _api.FileUploadComponent,
      IndexNameFormComponent: _api.IndexNameFormComponent,
      importerFactory: _api.importerFactory,
      getMaxBytes: _get_max_bytes.getMaxBytes,
      getMaxBytesFormatted: _get_max_bytes.getMaxBytesFormatted,
      hasImportPermission: _api.hasImportPermission,
      checkIndexExists: _api.checkIndexExists,
      getTimeFieldRange: _api.getTimeFieldRange,
      analyzeFile: _api.analyzeFile
    };
  }
}
exports.FileUploadPlugin = FileUploadPlugin;