"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapefileImporter = exports.SHAPEFILE_TYPES = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _core = require("@loaders.gl/core");
var _shapefile = require("@loaders.gl/shapefile");
var _shapefile_editor = require("./shapefile_editor");
var _abstract_geo_file_importer = require("../abstract_geo_file_importer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHAPEFILE_TYPES = ['.shp'];
exports.SHAPEFILE_TYPES = SHAPEFILE_TYPES;
class ShapefileImporter extends _abstract_geo_file_importer.AbstractGeoFileImporter {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_tableRowCount", null);
    (0, _defineProperty2.default)(this, "_dbfFile", null);
    (0, _defineProperty2.default)(this, "_prjFile", null);
    (0, _defineProperty2.default)(this, "_shxFile", null);
    (0, _defineProperty2.default)(this, "_iterator", void 0);
  }
  canPreview() {
    return this._dbfFile !== null && this._prjFile !== null && this._shxFile !== null;
  }
  renderEditor(onChange) {
    return !this.canPreview() ? /*#__PURE__*/_react.default.createElement(_shapefile_editor.ShapefileEditor, {
      shapefileName: this._getFile().name,
      onDbfSelect: file => {
        this._dbfFile = file;
        onChange();
      },
      onPrjSelect: file => {
        this._prjFile = file;
        onChange();
      },
      onShxSelect: file => {
        this._shxFile = file;
        onChange();
      }
    }) : null;
  }
  async _setTableRowCount() {
    if (!this._dbfFile) {
      return;
    }

    // read header from dbf file to get number of records in data file
    const dbfIterator = (await (0, _core.loadInBatches)(this._dbfFile, _shapefile.DBFLoader, {
      metadata: false,
      dbf: {
        encoding: 'latin1'
      }
    }))[Symbol.asyncIterator]();
    const {
      value
    } = await dbfIterator.next();
    if (value.nRecords && typeof value.nRecords === 'number') {
      this._tableRowCount = value.nRecords;
    }
  }
  _getProgress(featuresProcessed, bytesProcessed) {
    if (this._tableRowCount === null || this._tableRowCount === 0) {
      return 0;
    }
    if (featuresProcessed > this._tableRowCount) {
      return 100;
    }
    return featuresProcessed / this._tableRowCount * 100;
  }
  async _readNext(prevTotalFeaturesRead, prevTotalBytesRead) {
    const results = {
      bytesRead: 0,
      features: [],
      geometryTypesMap: new Map(),
      invalidFeatures: [],
      hasNext: true
    };
    if (this._iterator === undefined) {
      const sideCarFiles = [];
      if (this._dbfFile) {
        sideCarFiles.push(this._dbfFile);
      }
      if (this._prjFile) {
        sideCarFiles.push(this._prjFile);
      }
      if (this._shxFile) {
        sideCarFiles.push(this._shxFile);
      }
      const fileSystem = new _core._BrowserFileSystem([this._getFile(), ...sideCarFiles]);
      this._iterator = await (0, _core.loadInBatches)(this._getFile().name, _shapefile.ShapefileLoader, {
        fetch: fileSystem.fetch,
        // Reproject shapefiles to WGS84
        gis: {
          reproject: true,
          _targetCrs: 'EPSG:4326'
        },
        // Only parse the X & Y coordinates. Other coords not supported by Elasticsearch.
        shp: {
          _maxDimensions: 2
        },
        metadata: false
      });
      await this._setTableRowCount();
    }
    const {
      value: batch,
      done
    } = await this._iterator.next();
    if (!this._getIsActive() || done) {
      results.hasNext = false;
      return results;
    }
    for (let i = 0; i < batch.data.length; i++) {
      const feature = batch.data[i];
      if (!results.geometryTypesMap.has(feature.geometry.type)) {
        results.geometryTypesMap.set(feature.geometry.type, true);
      }
      results.features.push(feature);

      // Instead of tracking bytes read, which is difficult since reading from multiple binary files
      // track size by features
      const featureChars = JSON.stringify(feature).length;
      results.bytesRead = results.bytesRead + featureChars;
    }
    return results;
  }
}
exports.ShapefileImporter = ShapefileImporter;