"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceLines = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./reference_lines.scss");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../helpers");
var _reference_line_layer = require("./reference_line_layer");
var _reference_line = require("./reference_line");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ReferenceLines = ({
  layers,
  titles = {},
  ...rest
}) => {
  const referenceLines = layers.filter(layer => (0, _helpers.isReferenceLine)(layer));
  const referenceLinesNextValues = (0, _utils.getNextValuesForReferenceLines)(referenceLines);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, layers.flatMap(layer => {
    if (!layer.decorations) {
      return null;
    }
    const key = `referenceLine-${layer.layerId}`;
    if ((0, _helpers.isReferenceLine)(layer)) {
      const nextValue = referenceLinesNextValues[layer.decorations[0].fill][layer.layerId];
      return /*#__PURE__*/_react.default.createElement(_reference_line.ReferenceLine, (0, _extends2.default)({
        key: key,
        layer: layer
      }, rest, {
        nextValue: nextValue
      }));
    }
    const layerTitles = titles[layer.layerId];
    return /*#__PURE__*/_react.default.createElement(_reference_line_layer.ReferenceLineLayer, (0, _extends2.default)({
      key: key,
      layer: layer
    }, rest, {
      titles: layerTitles
    }));
  }));
};
exports.ReferenceLines = ReferenceLines;