"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDistinctSeries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * All the available categories of a datatable.
 */

/**
 * This method returns all the categories available in a datatable.
 * Here, categorical values are described as `bucket`, following the Elasticsearch bucket aggregation naming.
 * It describes as `parentSeries` all the categories available on the `first` available column.
 * It describes as `allSeries` each unique category/bucket available on all the categorical/bucket columns.
 * The output order depends on the original datatable configuration.
 */
const getDistinctSeries = (rows, bucketColumns) => {
  const parentBucketId = bucketColumns[0].id;
  // using unknown here because there the DatatableRow is just a plain Record<string, any>
  // At least we can prevent some issues, see https://github.com/elastic/kibana/issues/153437
  const parentSeries = new Set();
  const allSeries = new Set();
  bucketColumns.forEach(({
    id
  }) => {
    if (!id) return;
    rows.forEach(row => {
      allSeries.add(row[id]);
      if (id === parentBucketId) {
        parentSeries.add(row[parentBucketId]);
      }
    });
  });
  return {
    allSeries: [...allSeries],
    parentSeries: [...parentSeries]
  };
};
exports.getDistinctSeries = getDistinctSeries;