"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricVisRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
async function metricFilterable(dimensions, table, hasCompatibleActions) {
  var _dimensions$breakdown;
  const column = (0, _utils.getColumnByAccessor)((_dimensions$breakdown = dimensions.breakdownBy) !== null && _dimensions$breakdown !== void 0 ? _dimensions$breakdown : dimensions.metric, table.columns);
  const colIndex = table.columns.indexOf(column);
  const value = column ? table.rows[0][column.id] : undefined;
  return Boolean(await (hasCompatibleActions === null || hasCompatibleActions === void 0 ? void 0 : hasCompatibleActions({
    name: 'filter',
    data: {
      data: [{
        table,
        column: colIndex,
        row: 0,
        value
      }]
    }
  })));
}
const getMetricVisRenderer = deps => {
  return () => ({
    name: _common.EXPRESSION_METRIC_NAME,
    displayName: 'metric visualization',
    reuseDomNode: true,
    render: async (domNode, {
      visData,
      visConfig,
      overrides
    }, handlers) => {
      var _handlers$hasCompatib;
      const {
        core,
        plugins
      } = deps.getStartDeps();
      handlers.onDestroy(() => {
        (0, _reactDom.unmountComponentAtNode)(domNode);
      });
      const filterable = visData.rows.length ? await metricFilterable(visConfig.dimensions, visData, (_handlers$hasCompatib = handlers.hasCompatibleActions) === null || _handlers$hasCompatib === void 0 ? void 0 : _handlers$hasCompatib.bind(handlers)) : false;
      const renderComplete = () => {
        const executionContext = handlers.getExecutionContext();
        const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
        const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
        if (containerType && visualizationType) {
          var _plugins$usageCollect;
          (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_metric`]);
        }
        handlers.done();
      };
      const {
        MetricVis
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/metric_vis')));
      (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
        theme$: core.theme.theme$
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "mtrVis",
        css: (0, _react2.css)`
              height: 100%;
              width: 100%;
              display: flex;
              align-items: center;
              justify-content: center;
            `
      }, /*#__PURE__*/_react.default.createElement(MetricVis, {
        data: visData,
        config: visConfig,
        renderComplete: renderComplete,
        fireEvent: handlers.event,
        renderMode: handlers.getRenderMode(),
        filterable: filterable,
        overrides: overrides
      }))), domNode);
    }
  });
};
exports.getMetricVisRenderer = getMetricVisRenderer;