"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSeriesButton = AddSeriesButton;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _series_editor = require("../series_editor/series_editor");
var _use_series_storage = require("../hooks/use_series_storage");
var _use_app_data_view = require("../hooks/use_app_data_view");
var _constants = require("../configurations/constants");
var _exploratory_view_config = require("../contexts/exploratory_view_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddSeriesButton() {
  const [editorItems, setEditorItems] = (0, _react.useState)([]);
  const addSeriesButtonRef = (0, _react.useRef)(null);
  const {
    getSeries,
    allSeries,
    setSeries,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    loading,
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const {
    reportConfigMap
  } = (0, _exploratory_view_config.useExploratoryView)();
  (0, _react.useEffect)(() => {
    setEditorItems((0, _series_editor.getSeriesToEdit)({
      allSeries,
      dataViews,
      reportType,
      reportConfigMap
    }));
  }, [allSeries, getSeries, dataViews, loading, reportConfigMap, reportType]);
  const addSeries = () => {
    const prevSeries = allSeries === null || allSeries === void 0 ? void 0 : allSeries[0];
    const name = `${_use_series_storage.NEW_SERIES_KEY}-${editorItems.length + 1}`;
    const nextSeries = {
      name
    };
    if (addSeriesButtonRef !== null && addSeriesButtonRef !== void 0 && addSeriesButtonRef.current) {
      addSeriesButtonRef.current.blur();
    }
    const nextSeriesId = allSeries.length;
    if (reportType === 'data-distribution') {
      setSeries(nextSeriesId, {
        ...nextSeries,
        time: (prevSeries === null || prevSeries === void 0 ? void 0 : prevSeries.time) || _constants.DEFAULT_TIME
      });
    } else {
      setSeries(nextSeriesId, prevSeries ? nextSeries : {
        ...nextSeries,
        time: _constants.DEFAULT_TIME
      });
    }
  };
  const isAddDisabled = !reportType || (reportType === _constants.ReportTypes.CORE_WEB_VITAL || reportType === _constants.ReportTypes.DEVICE_DISTRIBUTION || reportType === _constants.ReportTypes.SINGLE_METRIC) && allSeries.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !reportType ? _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.addSeries.selectReportType', {
      defaultMessage: 'Please select report type before you can add series.'
    }) : isAddDisabled ? _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.addSeries.limitation', {
      defaultMessage: 'You can only add one series of this report type.'
    }) : ''
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yAddSeriesButtonAddSeriesButton",
    onClick: () => addSeries(),
    isDisabled: isAddDisabled,
    iconType: "plusInCircle",
    size: "s",
    buttonRef: addSeriesButtonRef
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.seriesBuilder.addSeries', {
    defaultMessage: 'Add series'
  })));
}