"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesName = SeriesName;
exports.StyledText = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_series_storage = require("../../hooks/use_series_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledText = (0, _styledComponents.default)(_eui.EuiText)`
  &.euiText.euiText--constrainedWidth {
    max-width: 200px;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
  }
`;
exports.StyledText = StyledText;
function SeriesName({
  series,
  seriesId
}) {
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [value, setValue] = (0, _react.useState)(series.name);
  const [isEditingEnabled, setIsEditingEnabled] = (0, _react.useState)(false);
  const inputRef = (0, _react.useRef)(null);
  const buttonRef = (0, _react.useRef)(null);
  const onChange = e => {
    setValue(e.target.value);
  };
  const onSave = () => {
    if (value !== series.name) {
      setSeries(seriesId, {
        ...series,
        name: value
      });
    }
  };
  const onOutsideClick = event => {
    if (event.target !== buttonRef.current) {
      setIsEditingEnabled(false);
      onSave();
    }
  };
  const onKeyDown = event => {
    if (event.key === 'Enter') {
      setIsEditingEnabled(false);
      onSave();
    }
  };
  (0, _react.useEffect)(() => {
    setValue(series.name);
  }, [series.name]);
  (0, _react.useEffect)(() => {
    if (isEditingEnabled && inputRef.current) {
      inputRef.current.focus();
    }
  }, [isEditingEnabled, inputRef]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, isEditingEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onOutsideClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: value,
    onChange: onChange,
    onBlur: onSave,
    onKeyDown: onKeyDown,
    fullWidth: true,
    inputRef: inputRef,
    "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.seriesName', {
      defaultMessage: 'Series name'
    }),
    "data-test-subj": "exploratoryViewSeriesNameInput"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StyledText, {
    grow: false
  }, value)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "exploratoryViewSeriesNameButton",
    onClick: () => setIsEditingEnabled(!isEditingEnabled),
    iconType: "pencil",
    "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.editName', {
      defaultMessage: 'Edit name'
    }),
    color: "text",
    buttonRef: buttonRef
  })));
}