"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiContentConsumer = void 0;
exports.MultiContentProvider = MultiContentProvider;
exports.useContent = useContent;
exports.useMultiContentContext = useMultiContentContext;
var _react = _interopRequireWildcard(require("react"));
var _use_multi_content = require("./use_multi_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const multiContentContext = /*#__PURE__*/(0, _react.createContext)({});
function MultiContentProvider({
  defaultValue,
  onChange,
  children
}) {
  const multiContent = (0, _use_multi_content.useMultiContent)({
    defaultValue,
    onChange
  });
  return /*#__PURE__*/_react.default.createElement(multiContentContext.Provider, {
    value: multiContent
  }, children);
}
const MultiContentConsumer = multiContentContext.Consumer;
exports.MultiContentConsumer = MultiContentConsumer;
function useMultiContentContext() {
  const ctx = (0, _react.useContext)(multiContentContext);
  if (Object.keys(ctx).length === 0) {
    throw new Error('useMultiContentContext must be used within a <MultiContentProvider />');
  }
  return ctx;
}

/**
 * Hook to declare a new content and get its defaultValue and a handler to update its content
 *
 * @param contentId The content id to be added to the "contents" map
 */
function useContent(contentId) {
  const isMounted = (0, _react.useRef)(false);
  const defaultValue = (0, _react.useRef)(undefined);
  const {
    updateContentAt,
    saveSnapshotAndRemoveContent,
    getData,
    getSingleContentData
  } = useMultiContentContext();
  const updateContent = (0, _react.useCallback)(content => {
    updateContentAt(contentId, content);
  }, [contentId, updateContentAt]);
  (0, _react.useEffect)(() => {
    return () => {
      // On unmount: save a snapshot of the data and remove content from our contents map
      saveSnapshotAndRemoveContent(contentId);
    };
  }, [contentId, saveSnapshotAndRemoveContent]);
  (0, _react.useEffect)(() => {
    if (isMounted.current === false) {
      isMounted.current = true;
    }
  }, []);
  if (isMounted.current === false) {
    // Only read the default value once, on component mount to avoid re-rendering the
    // consumer each time the multi-content validity ("isValid") changes.
    defaultValue.current = getSingleContentData(contentId);
  }
  return {
    defaultValue: defaultValue.current,
    updateContent,
    getData,
    getSingleContentData
  };
}