"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceAdded = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../shared/kibana");
var _loading = require("../../../../shared/loading");
var _query_params = require("../../../../shared/query_params");
var _add_source_logic = require("./add_source/add_source_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component merely triggers catchs the redirect from the oauth application and initializes the saving
 * of the params the oauth plugin sends back. The logic file now redirects back to sources with either a
 * success or error message upon completion.
 */
const SourceAdded = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const params = (0, _query_params.parseQueryParams)(search);
  const state = JSON.parse(params.state);
  const isOrganization = state.context !== 'account';
  const {
    setChromeIsVisible
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const addSourceLogic = (0, _add_source_logic.AddSourceLogic)({
    serviceType: state.service_type,
    initialStep: 'configure'
  });
  const {
    saveSourceParams
  } = (0, _kea.useActions)(addSourceLogic);

  // We don't want the personal dashboard to flash the Kibana chrome, so we hide it.
  setChromeIsVisible(isOrganization);
  (0, _react.useEffect)(() => {
    saveSourceParams(search, params, isOrganization);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_loading.Loading, null)));
};
exports.SourceAdded = SourceAdded;