"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKey = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKey = ({
  copy,
  toggleIsHidden,
  isHidden,
  text
}) => {
  const hideIcon = isHidden ? 'eye' : 'eyeClosed';
  const hideIconLabel = isHidden ? _constants.SHOW_API_KEY_LABEL : _constants.HIDE_API_KEY_LABEL;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": _constants.COPY_API_KEY_BUTTON_LABEL
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: toggleIsHidden,
    iconType: hideIcon,
    "aria-label": hideIconLabel,
    "aria-pressed": !isHidden,
    style: {
      marginRight: '0.25em'
    }
  }), text);
};
exports.ApiKey = ApiKey;