"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.languageDefinitions = void 0;
var _searchApiPanels = require("@kbn/search-api-panels");
var _curl = require("./curl");
var _go = require("./go");
var _javascript = require("./javascript");
var _php = require("./php");
var _python = require("./python");
var _ruby = require("./ruby");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const languageDefinitionRecords = {
  [_searchApiPanels.Languages.CURL]: _curl.curlDefinition,
  [_searchApiPanels.Languages.PYTHON]: _python.pythonDefinition,
  [_searchApiPanels.Languages.JAVASCRIPT]: _javascript.javascriptDefinition,
  [_searchApiPanels.Languages.PHP]: _php.phpDefinition,
  [_searchApiPanels.Languages.GO]: _go.goDefinition,
  [_searchApiPanels.Languages.RUBY]: _ruby.rubyDefinition
};
const languageDefinitions = Object.values(languageDefinitionRecords);
exports.languageDefinitions = languageDefinitions;