"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _page_template = require("../layout/page_template");
var _settings_logic = require("./settings_logic");
var _settings_panel = require("./settings_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Settings = () => {
  const {
    makeRequest,
    setPipeline
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    defaultPipeline,
    hasNoChanges,
    isLoading,
    pipelineState
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  const {
    extract_binary_content: extractBinaryContent,
    reduce_whitespace: reduceWhitespace,
    run_ml_inference: runMLInference
  } = pipelineState;
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: [_i18n.i18n.translate('xpack.enterpriseSearch.content.settings.breadcrumb', {
      defaultMessage: 'Settings'
    })],
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.settings.description",
        defaultMessage: "These settings apply to all new Elasticsearch indices created by Search ingestion mechanisms. For API ingest-based indices, remember to include the pipeline when you ingest documents. These features are powered by {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: _doc_links.docLinks.ingestPipelines,
            target: "_blank"
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.ingestLink', {
            defaultMessage: 'ingest pipelines'
          }))
        }
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.headerTitle', {
        defaultMessage: 'Content Settings'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        disabled: hasNoChanges,
        isLoading: isLoading,
        onClick: () => makeRequest(pipelineState),
        "data-test-subj": 'entSearchContentSettingsSaveButton'
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.saveButtonLabel', {
        defaultMessage: 'Save'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: hasNoChanges,
        isLoading: isLoading,
        onClick: () => setPipeline(defaultPipeline),
        "data-test-subj": 'entSearchContentSettingsResetButton'
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.resetButtonLabel', {
        defaultMessage: 'Reset'
      }))]
    },
    pageViewTelemetry: "Settings",
    isLoading: false
  }, /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.description', {
      defaultMessage: 'Extract searchable content from binary files, like PDFs and Word documents.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contactExtraction.label', {
      defaultMessage: 'Content extraction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      extract_binary_content: !pipelineState.extract_binary_content
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.title', {
      defaultMessage: 'Deployment wide content extraction'
    }),
    value: extractBinaryContent
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whiteSpaceReduction.description', {
      defaultMessage: 'Whitespace reduction will strip your full-text content of whitespace by default.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whitespaceReduction.label', {
      defaultMessage: 'Whitespace reduction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      reduce_whitespace: !pipelineState.reduce_whitespace
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whitespaceReduction.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide whitespace reduction'
    }),
    value: reduceWhitespace
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.description', {
      defaultMessage: 'ML Inference Pipelines will run as part of your pipelines. You will have to configure processors for each index individually on its pipelines page.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.label', {
      defaultMessage: 'ML Inference'
    }),
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.mlDocumentEnrichment,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.link', {
      defaultMessage: 'Learn more about document enrichment with ML'
    })),
    onChange: () => setPipeline({
      ...pipelineState,
      run_ml_inference: !pipelineState.run_ml_inference
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide ML Inference Pipelines extraction'
    }),
    value: runMLInference
  }));
};
exports.Settings = Settings;