"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FineTuneModelsButton = exports.E5_MULTILINGUAL_CALL_OUT_DISMISSED_KEY = exports.E5MultilingualDismissButton = exports.E5MultilingualCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../shared/kibana");
var _use_local_storage = require("../../../../../../shared/use_local_storage");
var _index_view_logic = require("../../../index_view_logic");
var _utils = require("../utils");
var _deploy_model = require("./deploy_model");
var _e5_multilingual_callout_logic = require("./e5_multilingual_callout_logic");
var _e5_multilingual_errors = require("./e5_multilingual_errors");
var _model_deployed = require("./model_deployed");
var _model_deployment_in_progress = require("./model_deployment_in_progress");
var _model_started = require("./model_started");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const E5_MULTILINGUAL_CALL_OUT_DISMISSED_KEY = 'enterprise-search-e5-multilingual-callout-dismissed';
exports.E5_MULTILINGUAL_CALL_OUT_DISMISSED_KEY = E5_MULTILINGUAL_CALL_OUT_DISMISSED_KEY;
const E5MultilingualDismissButton = ({
  dismiss
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.dismissButton', {
      defaultMessage: 'Dismiss E5 call out'
    }),
    iconType: "cross",
    onClick: dismiss
  });
};
exports.E5MultilingualDismissButton = E5MultilingualDismissButton;
const FineTuneModelsButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_utils.TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  })
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.e5MultilingualCallOut.fineTuneModelButton', {
  defaultMessage: 'Fine-tune performance'
}));
exports.FineTuneModelsButton = FineTuneModelsButton;
const E5MultilingualCallOut = props => {
  const isCompact = props.isCompact !== undefined ? props.isCompact : false;
  const isDismissable = props.isDismissable !== undefined ? props.isDismissable : false;
  const [calloutDismissed, setCalloutDismissed] = (0, _use_local_storage.useLocalStorage)(E5_MULTILINGUAL_CALL_OUT_DISMISSED_KEY, false);
  const [show, setShow] = (0, _react.useState)(() => {
    if (!isDismissable) return true;
    return !calloutDismissed;
  });
  const dismiss = (0, _react.useCallback)(() => {
    setShow(false);
    setCalloutDismissed(true);
  }, []);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isCreateButtonDisabled,
    isModelDownloadInProgress,
    isModelDownloaded,
    isModelRunningSingleThreaded,
    isModelStarted,
    e5MultilingualError,
    isStartButtonDisabled
  } = (0, _kea.useValues)(_e5_multilingual_callout_logic.E5MultilingualCalloutLogic);
  if (e5MultilingualError) return /*#__PURE__*/_react.default.createElement(_e5_multilingual_errors.E5MultilingualErrors, {
    error: e5MultilingualError
  });
  if (!show) return null;
  if (isModelDownloadInProgress) {
    return /*#__PURE__*/_react.default.createElement(_model_deployment_in_progress.ModelDeploymentInProgress, {
      dismiss: dismiss,
      isDismissable: isDismissable
    });
  } else if (isModelDownloaded) {
    return /*#__PURE__*/_react.default.createElement(_model_deployed.ModelDeployed, {
      dismiss: dismiss,
      ingestionMethod: ingestionMethod,
      isDismissable: isDismissable,
      isStartButtonDisabled: isStartButtonDisabled
    });
  } else if (isModelStarted) {
    return /*#__PURE__*/_react.default.createElement(_model_started.ModelStarted, {
      dismiss: dismiss,
      isCompact: isCompact,
      isDismissable: isDismissable,
      isSingleThreaded: isModelRunningSingleThreaded
    });
  }
  return /*#__PURE__*/_react.default.createElement(_deploy_model.DeployModel, {
    dismiss: dismiss,
    ingestionMethod: ingestionMethod,
    isDismissable: isDismissable,
    isCreateButtonDisabled: isCreateButtonDisabled
  });
};
exports.E5MultilingualCallOut = E5MultilingualCallOut;