"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurePipelineTabId = exports.ConfigurePipeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _index_view_logic = require("../../index_view_logic");
var _ml_inference_logic = require("./ml_inference_logic");
var _model_select = require("./model_select");
var _model_select_logic = require("./model_select_logic");
var _pipeline_select = require("./pipeline_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_NEW_TAB_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.tabs.createNew.name', {
  defaultMessage: 'Create new'
});
const USE_EXISTING_TAB_NAME = _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.tabs.useExisting.name', {
  defaultMessage: 'Use existing'
});
let ConfigurePipelineTabId;
exports.ConfigurePipelineTabId = ConfigurePipelineTabId;
(function (ConfigurePipelineTabId) {
  ConfigurePipelineTabId["CREATE_NEW"] = "create_new";
  ConfigurePipelineTabId["USE_EXISTING"] = "use_existing";
})(ConfigurePipelineTabId || (exports.ConfigurePipelineTabId = ConfigurePipelineTabId = {}));
const ConfigurePipeline = () => {
  const {
    addInferencePipelineModal: {
      configuration
    },
    formErrors
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    modelStateChangeError
  } = (0, _kea.useValues)(_model_select_logic.ModelSelectLogic);
  const {
    existingPipeline,
    pipelineName
  } = configuration;
  const nameError = formErrors.pipelineName !== undefined && pipelineName.length > 0;
  const inputsDisabled = configuration.existingPipeline !== false;
  const tabs = [{
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.nameLabel', {
        defaultMessage: 'Name'
      }),
      helpText: !nameError && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.name.helpText', {
        defaultMessage: 'Pipeline names are unique within a deployment and can only contain letters, numbers, underscores, and hyphens. This will create a pipeline named {pipelineName}.',
        values: {
          pipelineName: `ml-inference-${pipelineName}`
        }
      })),
      error: nameError && formErrors.pipelineName,
      isInvalid: nameError
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-uniqueName`,
      disabled: inputsDisabled,
      fullWidth: true,
      prepend: "ml-inference-",
      placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.namePlaceholder', {
        defaultMessage: 'Enter a unique name for this pipeline'
      }),
      value: pipelineName,
      onChange: e => setInferencePipelineConfiguration({
        ...configuration,
        isPipelineNameUserSupplied: e.target.value.length > 0,
        pipelineName: e.target.value
      })
    })), modelStateChangeError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.modelStateChangeError.title', {
        defaultMessage: 'Error changing model state'
      }),
      color: "danger",
      iconType: "error"
    }, modelStateChangeError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.titleSelectTrainedModel', {
        defaultMessage: 'Select a trained ML Model'
      })
    }, /*#__PURE__*/_react.default.createElement(_model_select.ModelSelect, null)))),
    id: ConfigurePipelineTabId.CREATE_NEW,
    name: CREATE_NEW_TAB_NAME
  }, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.existingPipelineLabel', {
        defaultMessage: 'Select an existing inference pipeline'
      })
    }, /*#__PURE__*/_react.default.createElement(_pipeline_select.PipelineSelect, {
      "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-selectExistingPipeline`
    })))),
    id: ConfigurePipelineTabId.USE_EXISTING,
    name: USE_EXISTING_TAB_NAME
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.title', {
    defaultMessage: 'Configure a pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.steps.configure.description', {
    defaultMessage: 'Build or reuse a child pipeline that will be used as a processor in your main pipeline.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    autoFocus: "selected",
    initialSelectedTab: tabs[existingPipeline ? 1 : 0],
    onTabClick: tab => {
      const isExistingPipeline = tab.id === ConfigurePipelineTabId.USE_EXISTING;
      if (isExistingPipeline !== configuration.existingPipeline) {
        setInferencePipelineConfiguration({
          ..._ml_inference_logic.EMPTY_PIPELINE_CONFIGURATION,
          existingPipeline: isExistingPipeline
        });
      }
    }
  }));
};
exports.ConfigurePipeline = ConfigurePipeline;