"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateApiKeyPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _modal = require("./components/generate_api_key_modal/modal");
var _getting_started = require("./components/getting_started/getting_started");
var _index_view_logic = require("./index_view_logic");
var _overview = require("./overview.logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerateApiKeyPanel = () => {
  const {
    isGenerateModalOpen
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    indexName,
    isHiddenIndex
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    closeGenerateModal
  } = (0, _kea.useActions)(_overview.OverviewLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isGenerateModalOpen && /*#__PURE__*/_react.default.createElement(_modal.GenerateApiKeyModal, {
    indexName: indexName,
    onClose: closeGenerateModal
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl"
  }, isHiddenIndex ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.emptyPrompt.body', {
      defaultMessage: 'We do not recommend adding documents to an externally managed index.'
    })),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.emptyPrompt.title', {
      defaultMessage: 'Index managed externally'
    }))
  }) : /*#__PURE__*/_react.default.createElement(_getting_started.APIGettingStarted, null)))));
};
exports.GenerateApiKeyPanel = GenerateApiKeyPanel;