"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReadableCrawlerRule = exports.getReadableCrawlerPolicy = exports.getCrawlRulePathPatternTooltip = exports.CrawlRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _flash_messages = require("../../../../../shared/flash_messages");
var _generic_endpoint_inline_editable_table = require("../../../../../shared/tables/generic_endpoint_inline_editable_table");
var _types = require("../../../../api/crawler/types");
var _crawler_domain_detail_logic = require("./crawler_domain_detail_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReadableCrawlerRule = rule => {
  switch (rule) {
    case _types.CrawlerRules.beginsWith:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesCrawlerRules.beginsWithLabel', {
        defaultMessage: 'Begins with'
      });
    case _types.CrawlerRules.endsWith:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesCrawlerRules.endsWithLabel', {
        defaultMessage: 'Ends with'
      });
    case _types.CrawlerRules.contains:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesCrawlerRules.containsLabel', {
        defaultMessage: 'Contains'
      });
    case _types.CrawlerRules.regex:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesCrawlerRules.regexLabel', {
        defaultMessage: 'Regex'
      });
  }
};
exports.getReadableCrawlerRule = getReadableCrawlerRule;
const getReadableCrawlerPolicy = policy => {
  switch (policy) {
    case _types.CrawlerPolicies.allow:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesPolicies.allowLabel', {
        defaultMessage: 'Allow'
      });
    case _types.CrawlerPolicies.deny:
      return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesPolicies.disallowLabel', {
        defaultMessage: 'Disallow'
      });
  }
};
exports.getReadableCrawlerPolicy = getReadableCrawlerPolicy;
const getCrawlRulePathPatternTooltip = crawlRule => {
  if (crawlRule.rule === _types.CrawlerRules.regex) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.regexPathPatternTooltip', {
      defaultMessage: 'The path pattern is a regular expression compatible with the Ruby language regular expression engine.'
    });
  }
  return _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.pathPatternTooltip', {
    defaultMessage: 'The path pattern is a literal string except for the asterisk (*) character, which is a meta character that will match anything.'
  });
};
exports.getCrawlRulePathPatternTooltip = getCrawlRulePathPatternTooltip;
const DEFAULT_DESCRIPTION = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.crawler.crawlRulesTable.description",
  defaultMessage: "Create a crawl rule to include or exclude pages whose URL matches the rule. Rules run in sequential order, and each URL is evaluated according to the first match."
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: _doc_links.docLinks.crawlerManaging,
  target: "_blank",
  external: true
}, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.descriptionLinkText', {
  defaultMessage: 'Learn more about crawl rules'
})));
const CrawlRulesTable = ({
  description = DEFAULT_DESCRIPTION,
  domainId,
  indexName,
  crawlRules,
  defaultCrawlRule,
  title
}) => {
  const {
    updateCrawlRules
  } = (0, _kea.useActions)(_crawler_domain_detail_logic.CrawlerDomainDetailLogic);
  const columns = [{
    editingRender: (crawlRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-crawlRules-policy",
      fullWidth: true,
      hasNoInitialSelection: true,
      value: crawlRule.policy,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      options: [_types.CrawlerPolicies.allow, _types.CrawlerPolicies.deny].map(policyOption => ({
        text: getReadableCrawlerPolicy(policyOption),
        value: policyOption
      }))
    }),
    field: 'policy',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.policyTableHead', {
      defaultMessage: 'Policy'
    }),
    render: crawlRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, getReadableCrawlerPolicy(crawlRule.policy))
  }, {
    editingRender: (crawlRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-crawlRules-rule",
      fullWidth: true,
      hasNoInitialSelection: true,
      value: crawlRule.rule,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid,
      options: [_types.CrawlerRules.beginsWith, _types.CrawlerRules.endsWith, _types.CrawlerRules.contains, _types.CrawlerRules.regex].map(ruleOption => ({
        text: getReadableCrawlerRule(ruleOption),
        value: ruleOption
      }))
    }),
    field: 'rule',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.ruleTableHead', {
      defaultMessage: 'Rule'
    }),
    render: crawlRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, getReadableCrawlerRule(crawlRule.rule))
  }, {
    editingRender: (crawlRule, onChange, {
      isInvalid,
      isLoading
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: crawlRule.pattern,
      onChange: e => onChange(e.target.value),
      disabled: isLoading,
      isInvalid: isInvalid
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: getCrawlRulePathPatternTooltip(crawlRule),
      type: "iInCircle",
      position: "top"
    }))),
    field: 'pattern',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.pathPatternTableHead', {
      defaultMessage: 'Path pattern'
    }),
    render: crawlRule => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, crawlRule.pattern)
  }];
  const crawlRulesRoute = `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}/crawl_rules`;
  const domainRoute = `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}`;
  const getCrawlRuleRoute = crawlRule => `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}/crawl_rules/${crawlRule.id}`;
  return /*#__PURE__*/_react.default.createElement(_generic_endpoint_inline_editable_table.GenericEndpointInlineEditableTable, {
    addButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.addButtonLabel', {
      defaultMessage: 'Add crawl rule'
    }),
    columns: columns,
    description: description,
    instanceId: "CrawlRulesTable",
    items: crawlRules,
    addRoute: crawlRulesRoute,
    dataProperty: "crawl_rules",
    deleteRoute: getCrawlRuleRoute,
    updateRoute: getCrawlRuleRoute,
    reorderRoute: domainRoute,
    onAdd: (_, newCrawlRules) => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    onDelete: (_, newCrawlRules) => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
      (0, _flash_messages.flashSuccessToast)(_i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRulesTable.deleteSuccessToastMessage', {
        defaultMessage: 'The crawl rule has been deleted.'
      }));
    },
    onUpdate: (_, newCrawlRules) => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    onReorder: newCrawlRules => {
      updateCrawlRules(newCrawlRules);
      (0, _flash_messages.clearFlashMessages)();
    },
    title: title || '',
    uneditableItems: defaultCrawlRule ? [defaultCrawlRule] : undefined,
    canRemoveLastItem: true
  });
};
exports.CrawlRulesTable = CrawlRulesTable;