"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchedulePanel = exports.ConnectorSchedulingComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _unsaved_changes_prompt = require("../../../../shared/unsaved_changes_prompt");
var _routes = require("../../../routes");
var _types = require("../../../types");
var indices = _interopRequireWildcard(require("../../../utils/indices"));
var _index_view_logic = require("../index_view_logic");
var _search_index = require("../search_index");
var _full_content = require("./connector_scheduling/full_content");
var _connector_scheduling_logic = require("./connector_scheduling_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchedulePanel = ({
  title,
  description,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children)));
};
exports.SchedulePanel = SchedulePanel;
const ConnectorSchedulingComponent = () => {
  var _index$connector$conf;
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    ingestionStatus,
    hasDocumentLevelSecurityFeature,
    hasIncrementalSyncFeature
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    index
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    hasChanges
  } = (0, _kea.useValues)(_connector_scheduling_logic.ConnectorSchedulingLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const shouldShowIncrementalSync = hasIncrementalSyncFeature && productFeatures.hasIncrementalSyncEnabled;
  const shouldShowAccessControlSync = hasDocumentLevelSecurityFeature && productFeatures.hasDocumentLevelSecurityEnabled;
  if (!indices.isConnectorIndex(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const isDocumentLevelSecurityDisabled = !((_index$connector$conf = index.connector.configuration.use_document_level_security) !== null && _index$connector$conf !== void 0 && _index$connector$conf.value);
  if (index.connector.status === _searchConnectors.ConnectorStatus.CREATED || index.connector.status === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "iInCircle",
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.notConnected.title', {
        defaultMessage: 'Configure your connector to schedule a sync'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.notConnected.description', {
      defaultMessage: 'Configure and deploy your connector, then return here to set your sync schedule. This schedule will dictate the interval that the connector will sync with your data source for updated documents.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      "data-telemetry-id": "entSearchContent-connector-scheduling-configure",
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
        indexName: index.name,
        tabId: _search_index.SearchIndexTabId.CONFIGURATION
      }),
      fill: true,
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.notConnected.button.label', {
      defaultMessage: 'Configure'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: hasChanges,
    messageText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.unsaved.title', {
      defaultMessage: 'You have not saved your changes, are you sure you want to leave?'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), ingestionStatus === _types.IngestionStatus.ERROR ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.error.title', {
      defaultMessage: 'Review your connector configuration for reported errors.'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.connectorScheduling.page.description",
    defaultMessage: "Your connector is now deployed. Schedule recurring content and access control syncs here. If you want to run a quick test, launch a one-time sync using the {sync} button.",
    values: {
      sync: /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.page.sync.label', {
        defaultMessage: 'Sync'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SchedulePanel, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.contentSync.title', {
      defaultMessage: 'Content sync'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.contentSync.description', {
      defaultMessage: 'Fetch content to create or update your Elasticsearch documents.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_full_content.ConnectorContentScheduling, {
    type: _searchConnectors.SyncJobType.FULL,
    index: index
  })), shouldShowIncrementalSync && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_full_content.ConnectorContentScheduling, {
    type: _searchConnectors.SyncJobType.INCREMENTAL,
    index: index
  }))))), shouldShowAccessControlSync && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SchedulePanel, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.documentLevelSecurity.title', {
      defaultMessage: 'Document Level Security'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.documentLevelSecurity.description', {
      defaultMessage: 'Control the documents users can access, based on their permissions and roles. Schedule syncs to keep these access controls up to date.'
    })
  }, /*#__PURE__*/_react.default.createElement(_full_content.ConnectorContentScheduling, {
    type: _searchConnectors.SyncJobType.ACCESS_CONTROL,
    index: index,
    hasPlatinumLicense: hasPlatinumLicense
  }))), isDocumentLevelSecurityDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.documentLevelSecurity.dlsDisabledCallout.title', {
      defaultMessage: 'Access control syncs not allowed'
    }),
    color: "warning",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.documentLevelSecurity.dlsDisabledCallout.text",
    defaultMessage: "{link} for this connector to activate these options.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName: index.name,
          tabId: _search_index.SearchIndexTabId.CONFIGURATION
        })
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.schedulePanel.documentLevelSecurity.dlsDisabledCallout.link', {
        defaultMessage: 'Enable document level security'
      }))
    }
  }))))))));
};
exports.ConnectorSchedulingComponent = ConnectorSchedulingComponent;